//  OPERACIONES ELEMENTALES CON VECTORES

//  opelvect.h

// NECESITA:

//#include <stdio.h>
//#include <stdlib.h>
//#include <math.h>

//#include "varios.h"


void   alea(double *x, int n, double a, double b);

void   alea(double *x, int n, int i, int j);

void   alea(int *x, int n, int i, int j);

void   alea(double **a, int m, int n, int k1, int k2);

void   alea1(double **a, int m, int n, int k1, int k2);


double suma(double *x, int n);

int    suma(int *x, int n);

double suma(double *x, int salto, int n);

void   sumaXY(double *x, double *y, double *z, int n);

void   sumaXY(double *x, int saltox, double *y, int saltoy,
              double *z, int saltoz, int n);

double prod(double *x, int n);

double prod(double *x, int salto, int n);

double prom(double *x, int n);

double prom(double *x, int salto, int n);


void   inter(double *x, double *y, int n);

void   inter(double *x, int saltox, double *y, int saltoy, int n);


double norma2(double *x, int n);

double norma2(double *x, int salto, int n);

double normaMax(double *x, int n);

double normMaxA(double *a, int m, int n, int N);


double dist2(double *x, double *y, int n);

double dist2(double *x, int saltox, double *y, int saltoy, int n);

double dist2(double **a, double **b, int m, int n);

double dist2_1(double **a, double **b, int m, int n);


double evalPol(double *p, int n, double t);

double divSint(double *p, int n, double t, double *q);


double prodEsc(double *x, double *y, int n);

double prodEsc(double *x, int saltox, double *y, int saltoy, int n);


void   alfaX(double alfa, double *x, int n);

void   alfaX(double alfa, double *x, int salto, int n);


void   XMasAlfaY(double *x, double alfa, double *y, int n);

void   XMasAlfaY(double *x, int saltox, double alfa, double *y,
	       int saltoy, int n);


void   XIglK(double *x, int n, double k);

void   XIglK(int *x, int n, int k);

void   XIglK(double *x, int salto, int n, double k);

void   XIglK(double **a, int m, int n, double k);

void   XIglK1(double **a, int m, int n, double k);


void   XIglY(double *x, double *y, int n);

void   XIglY(double **a, double **b, int m, int n);

void   XIglY(double *x, int saltox, double *y, int saltoy, int n);

void   XIglY1(double **a, double **b, int m, int n);

void   XIglAlfaY(double *x, double alfa, double *y, int n);



void   XIglAlfaY(double *x, int saltox, double alfa, double *y,
	       int saltoy, int n);

void   ZIglXMasAlfaY(double *z, double *x, double alfa, 
                   double *y, int n);

double maxi(double *x, int n);

int    maxi(int *x, int n);

double maxi(double *x, int salto, int n);

double maxPos(double *x, int salto, int n, int &posi);

double maxAbs(double *x, int n);

double maxAbs(double *x, int salto, int n);

double maxAbsPos(double *x, int n, int &posi);

double maxAbsPos(double *x, int salto, int n, int &posi);

double mini(double *x, int n);

int    mini(int *x, int n);

double minAbs(double *x, int n);

double minAbs(double *x, int salto, int n);

double maxAbsSubcol(double **a, int i1, int i2, int j, int &pos);


void   ordBurb(double *x, int n);

void   ordBurb(double *x, int salto, int n);

void   ordBurbXY(double *x, double *y, int n);


//==========================================================
//-----------------------------------------------------------
void alea(double *x, int n, double a, double b)
{
  // vector aleatorio, valores entre  a y b
  // Utiliza: alea

  int k;

  for( k=0; k<n; k++) x[k] = alea(a, b);
}



//-----------------------------------------------------------
void alea(double *x, int n, int i, int j)
{
  // vector aleatorio con valores double pero enteros entre 
  // enteros i, j

  int k;

  for( k=0; k<n; k++) x[k] = double( alea(i, j));
}
//-----------------------------------------------------------
void alea(double **a, int m, int n, int k1, int k2)
{
  // Matriz aleatoria con valores double pero enteros entre 
  // enteros k1  y  k2.
  // tama~no  m x n

  int k;

  for( k=0; k<m ; k++) alea( &a[k][0], n, k1, k2);
}
//-----------------------------------------------------------
void alea1(double **a, int m, int n, int k1, int k2)
{
  // Matriz aleatoria con valores double pero enteros entre 
  // enteros k1, k2 
  // tama~no  m x n
  // SUBINDICES A PARTIR DE 1

  int k;

  for( k=1; k<=m ; k++) alea( &a[k][1], n, k1, k2);
}
//-----------------------------------------------------------
void alea(int *x, int n, int i, int j)
{
  // vector entero aleatorio, entero valores entre  i  y j.

  int k;

  for( k=0; k<n; k++) x[k] = alea(i, j);
}


//-----------------------------------------------------------
double suma(double *x, int n)
{
  // suma de los elementos del 'vector'  x

  double *p, *pFin;
  double s = 0.0;


  if( n < 0 ) {
    printf(" suma: n = %d negativo.\n", n);
    return s;
  }
  if( n ==  0 ) return s;

  p = x;
  pFin = x+n;
  while( p < pFin) s += *p++;
  return s;
}


//-----------------------------------------------------------
int suma(int *x, int n)
{
  // suma de los elementos del 'vector'  x

  int *p, *pFin;
  int s = 0;


  if( n < 0 ) {
    printf(" suma: n = %d negativo.\n", n);
    return s;
  }
  if( n == 0 ) return s;

  p = x;
  pFin = x+n;
  while( p < pFin) s += *p++;
  return s;
}

//-----------------------------------------------------------
double prod(double *x, int n)
{
  // producto de los elementos del 'vector'  x

  double *p, *pFin;
  double s = 1.0;

  if( n < 0 ) {
    printf(" prod: n = %d negativo.\n", n);
    return s;
  }
  if( n ==  0 ) return s;

  p = x;
  pFin = x+n;
  while( p < pFin) s *= *p++;
  return s;
}

//-----------------------------------------------------------
double prom(double *x, int n)
{
  // promedio de los elementos del 'vector'  x

  if( n <= 0) {
    printf(" prom: n = %d inadecuado.\n", n);
    return 0.0;
  }
  return suma(x, n)/double(n);
}

//-----------------------------------------------------------
double norma2(double *x, int n)
{
  // norma 2 : norma euclideana de  x

  double *pxi, *pxn, s = 0.0, xi;

  if( n < 0 ) {
    printf(" norma2: n = %d negativo.\n", n);
    return s;
  }
  if( n ==  0 ) return s;

  pxn = x+n;
  pxi = x;
  while( pxi < pxn) {
    xi = *pxi++;
    s += xi*xi;
  }
  return sqrt(s);
}

//----------------------------------------------------------
double normaMax(double *x, int n)
{
  // norma del maximo de  x

  double *pxi, *pxn, vamax  = 0.0, axi;

  if( n < 0 ) {
    printf(" normaMax: n = %d negativo.\n", n);
    return vamax;
  }
  if( n ==  0 ) return vamax;

  pxn = x+n;
  pxi = x;
  while( pxi < pxn) {
    axi = fabs( *pxi++ );
    if( axi > vamax ) vamax = axi;
  }
  return vamax;
}


//----------------------------------------------------------
double normMaxA(double *a, int m, int n, int N)
{
  // norma del maximo de  una matriz  A  de tamano  mxn
  // almacenada por filas, o sea, 
  //   
  //   max | aij |  para todo i, j.

  // N  indica la diferencia entre las posiciones de un 
  //    elemento de  A  y el siguiente de la misma columna;
  //    esto quiere decir que hay  N  posiciones para
  //    almacenar los  n  elementos de una fila
  //    Obviamente se debe cumplir   n <= N.

  double *pai, *paim, vamax  = 0.0;

  if( n<0 || m<0 || N<m ) {
    printf(" normMaxA: errores en m, n, N: %d %d %d\n",m,n,N);
    return vamax;
  }
  if( m == 0 || n ==  0 ) return vamax;

  pai  = a;
  paim = a + m*N;
  while( pai < paim) {
    vamax = maxi( vamax, normaMax(pai, n) );
    pai += N;
  }
  return vamax;
}


//-----------------------------------------------------------
double evalPol(double *p, int n, double t)
{
  // evaluacion de p(t) utilizando el esquema de Horner
  // p(x) = p[0] + p[1]*x + p[2]*x*x + ... + p[n]*x^n

  double pt, *pi;

  pi = p + n;
  pt = *pi;
  pi--;
  while( pi >= p) pt = pt*t + *pi--;
  return pt;
}

//-----------------------------------------------------------
double divSint(double *p, int n, double t, double *q)
{
  // division sintetica de  p(x)/(x-t)
  // n  es el grado del polinomio
  // p(x) = p[0] + p[1]*x + p[2]*x*x + ... + p[n]*x^n
  // devuelve el residuo
  // q  contiene el cociente

  double pt;  // p(t) : residuo
  double *pi, *qi;

  pi = p + n;
  pt = *pi;
  pi--;
  qi = q+n-1;
  while( pi >= p) {
    *qi-- = pt;
    pt = pt*t + *pi--;
    //qi--;
  }
  return pt;
}

//-----------------------------------------------------------
double prodEsc(double *x, double *y, int n)
{
  // producto "interno"  x.y

  double s = 0.0;
  double *pxi, *pyi, *pxn;

  if( n < 0) {
    printf("prodEsc: n negativo\n");
    return s;
  }

  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) s += (*pxi++)*(*pyi++);
  return s;
}
//-----------------------------------------------------------
double dist2(double *x, double *y, int n)
{
  // distancia euclideana (Holder, orden 2) entre  x  y

  double s = 0.0;
  double *pxi, *pyi, *pxn, xiyi;

  if( n < 0) {
    printf("dist2: n negativo\n");
    return s;
  }

  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) {
    xiyi = (*pxi++) - (*pyi++);
    s += xiyi*xiyi;
  }
  return sqrt(s);
}

//-----------------------------------------------------------
double dist2(double **a, double **b, int m, int n)
{
  // distancia euclideana (Holder, orden 2) entre  A  y  B  
  // dos matrices  m x n
  // SUBINDICES A PARTIR DE 0

  double s = 0.0, t;
  int i;

  for( i=0; i < m; i++) {
    t = dist2( &a[i][0], &b[i][0], n);
    s += t*t;
  }
  return sqrt(s);
}

//-----------------------------------------------------------
double dist2_1(double **a, double **b, int m, int n)
{
  // distancia euclideana (Holder, orden 2) entre  A  y  B  
  // dos matrices  m x n
  // SUBINDICES A PARTIR DE 1

  double s = 0.0, t;
  int i;

  for( i=1; i <= m; i++) {
    t = dist2( &a[i][1], &b[i][1], n);
    s += t*t;
  }
  return sqrt(s);
}

//-----------------------------------------------------------
void alfaX(double alfa, double *x, int n)
{
  // x = alfa * x

  double *pxi, *pxn;

  if( n < 0) {
    printf("alfaX: n negativo\n");
    return;
  }
  pxi = x;
  pxn = x + n;
  while( pxi < pxn) *pxi++ *= alfa;
}
//-----------------------------------------------------------
void XMasAlfaY(double *x, double alfa, double *y, int n)
{
  // x = x + alfa * y

  double *pxi, *pxn, *pyi;

  if( n < 0) {
    printf("XMasAlfaY: n negativo\n");
    return;
  }


  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) *pxi++ += alfa*(*pyi++);
}
//----------------------------------------------------------
void ZIglXMasAlfaY(double *z, double *x, double alfa, double *y, int n)
{
  // z = x + alfa * y

  double *pxi, *pxn, *pyi, *pzi;

  if( n < 0) {
    printf("ZIglXMasAlfaY: n negativo\n");
    return;
  }

  pzi = z;
  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) *pzi++ = *pxi++ + alfa*(*pyi++);
}
//-----------------------------------------------------------
void XIglK(double *x, int n, double k)
{
  // x = k

  double *pxi, *pxn;

  if( n < 0) {
    printf("XIglK: n negativo\n");
    return;
  }
  pxi = x;
  pxn = x + n;
  while( pxi < pxn) *pxi++ = k;
}
//-----------------------------------------------------------
void XIglK(int *x, int n, int k)
{
  // x = k

  int *pxi, *pxn;

  if( n < 0) {
    printf("XIglK: n negativo\n");
    return;
  }
  pxi = x;
  pxn = x + n;
  while( pxi < pxn) *pxi++ = k;
}
//-----------------------------------------------------------
void XIglK(double **a, int m, int n, double k)
{
  // A = k
  // matriz = una constante
  // A  es  m x n
  // SUBINDICES A PARTIR DE 0
 
  for( int i = 0; i < m; i++ ) XIglK( &a[i][0], n, k);
}

//-----------------------------------------------------------
void XIglK1(double **a, int m, int n, double k)
{
  // A = k
  // matriz = una constante
  // A  es  m x n
  // SUBINDICES A PARTIR DE 1
 
  for( int i = 1; i <= m; i++ ) XIglK( &a[i][1], n, k);
}

//-----------------------------------------------------------
void XIglY(double *x, double *y, int n)
{
  // x = y

  double *pxi, *pxn, *pyi;

  if( n < 0) {
    printf("XIglY: n negativo\n");
    return;
  }
  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) *pxi++ = *pyi++;
}

//-----------------------------------------------------------
void XIglY(double **a, double **b, int m, int n)
{
  // A = B
  // SUBINDICES A PARTIR DE 0

  int i;
  for( i = 0; i < m; i++) XIglY( &a[i][0], &b[i][0], n);
}

//-----------------------------------------------------------
void XIglY1(double **a, double **b, int m, int n)
{
  // A = B
  // SUBINDICES A PARTIR DE 1

  int i;
  for( i = 1; i <= m; i++) XIglY( &a[i][1], &b[i][1], n);
}



//-----------------------------------------------------------

void XIglAlfaY(double *x, double alfa, double *y, int n)
{
  // x = alfa * y

  double *pxi, *pxn, *pyi;

  if( n < 0) {
    printf("XIglAlfaY: n negativo\n");
    return;
  }

  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) *pxi++ = alfa*(*pyi++);
}



//-----------------------------------------------------------
void inter(double *x, double *y, int n)
{
  // intercambiar  x  y

  double *pxi, *pxn, *pyi, t;

  if( n < 0) {
    printf("inter: n negativo\n");
    return;
  }
  pxi = x;
  pyi = y;
  pxn = x + n;
  while( pxi < pxn) {
    t = *pxi;
    *pxi++ = *pyi;
    *pyi++ = t;
  }
}
//-----------------------------------------------------------
double maxi(double *x, int n)
{
  // maximo  xi

  double *pxi, *pxn, maxi = -1.0E100, xi;

  if( n < 0) {
    printf("maxi: n negativo\n");
    return maxi;
  }

  pxi = x;
  pxn = x + n;
  while( pxi < pxn) {
    xi = *pxi++;
    if( xi > maxi) maxi = xi;
  }
  return maxi;
}
//-----------------------------------------------------------
int maxi(int *x, int n)
{
  // maximo  xi

  int *pxi, *pxn, maxi = -10000, xi;

  if( n < 0) {
    printf("maxi: n negativo\n");
    return maxi;
  }

  pxi = x;
  pxn = x + n;
  while( pxi < pxn) {
    xi = *pxi++;
    if( xi > maxi) maxi = xi;
  }
  return maxi;
}
//-----------------------------------------------------------
double mini(double *x, int n)
{
  // mini  xi

  double *pxi, *pxn, mini = 1.0E100, xi;

  if( n < 0) {
    printf("mini: n negativo\n");
    return mini;
  }

  pxi = x;
  pxn = x + n;
  while( pxi < pxn) {
    xi = *pxi++;
    if( xi < mini) mini = xi;
  }
  return mini;
}
//-----------------------------------------------------------
int mini(int *x, int n)
{
  // mini  xi

  int *pxi, *pxn, mini = 10000, xi;

  if( n < 0) {
    printf("mini: n negativo\n");
    return mini;
  }

  pxi = x;
  pxn = x + n;
  while( pxi < pxn) {
    xi = *pxi++;
    if( xi < mini) mini = xi;
  }
  return mini;
}



//-----------------------------------------------------------
double maxAbs(double *x, int n)
{
  // maximo  |xi|

  double *pxi, *pxn, maxi = -1.0E100, axi;

  if( n < 0) {
    printf("maxAbs: n negativo\n");
    return maxi;
  }
  pxi = x;
  pxn = x + n;
  while( pxi < pxn) {
    axi = fabs(*pxi++);
    if( axi > maxi) maxi = axi;
  }
  return maxi;
}


//----------------------------------------------------------
double  maxAbsSubcol(double **a, int i1, int i2, int j, int &pos)
{
  // maximo valor absoluto de una subcolumna de la columna  j
  // max { | a(i,j) | : i1 <= i <= i2 }

  // tambien calcula el indice (posicion) del max. valor abs.

  int i;
  double aa;
  
  double maxVA = -1.0;

  pos = -1;

  if( i1 > i2 ) printf("RARO: i1 > i2 : %d , %d.\n", i1, i2);
  for( i = i1; i <= i2; i++){
    aa = fabs( a[i][j] );
    if( aa > maxVA ) {
      maxVA = aa;
      pos = i; 
    }
  }
  return maxVA;
}



//-----------------------------------------------------------
double minAbs(double *x, int n)
{
  // min  |xi|

  double *pxi, *pxn, mini = 1.0E100, axi;

  if( n < 0) {
    printf("minAbs: n negativo\n");
    return mini;
  }
  pxi = x;
  pxn = x + n;
  while( pxi < pxn) {
    axi = fabs(*pxi++);
    if( axi < mini) mini = axi;
  }
  return mini;
}


//-----------------------------------------------------------
double maxAbsPos(double *x, int n, int &posi)
{
  // maximo  |xi|

  // posi contendra la posicion del maximo valor abs.

  double *pxi, *pxn, maxi = -1.0E100, axi;
  int i;

  posi = -1;
  pxi = x;
  pxn = x + n;
  i = 0;
  while( pxi < pxn) {
    axi = fabs(*pxi++);
    if( axi > maxi) {
      maxi = axi;
      posi = i;
    }
    i++;
  }
  return maxi;
}



//------------------------------------------------------------------------------
void sumaXY(double *x, double *y, double *z, int n)
{
  // z = x + y

  double *pxi, *pyi, *pzi, *pxn;

  if( n <= 0) {
    printf(" sumaXY :  n <= 0.\n");
    return;
  }

  pxi = x;
  pyi = y;
  pzi = z;
  pxn = x + n;
  while( pxi < pxn ) *pzi++ = *pxi++ + *pyi++;
}



//-----------------------------------------------------------
void ordBurb(double *x, int n)
{
  // ordena, de manera creciente, el vector  x
  // por el m\'etodo burbuja

  int nCamb, m;
  double *pxi, *pxi1, *pxm, t;

  if( n < 0) {
    printf("ordBurb: n negativo.\n");
    return;
  }
  if( n <= 1 ) return;


  //printf(" en ordBurb\n");
  for( m = n-1; m >= 0; m--) {
    nCamb = 0;
    pxi = x;
    pxi1 = x + 1;
    pxm = x + m;
    while( pxi < pxm) {
      if( *pxi > *pxi1) {
        t = *pxi;
        *pxi++ = *pxi1;
        *pxi1++ = t;
        nCamb++;
      }
      else{
        pxi++;
        pxi1++;
      }
      //printf(" dir x = %p\n", x);
      //escrVect(x, n);
    }
    //printf("fin pasada\n");
    if( nCamb == 0) return;
  }
}


//-----------------------------------------------------------
void ordBurbXY(double *x, double *y, int n)
{
  // Ordena, de manera creciente, el vector  x
  // por el m\'etodo burbuja.
  // El vector  y  es reorganizado de acuerdo a  x

  int nCamb, m;
  double *pxi, *pxi1, *pxm, t, *pyi, *pyi1;

  if( n < 0) {
    printf("ordBurb: n negativo.\n");
    return;
  }
  if( n <= 1 ) return;

  //printf(" en ordBurb\n");
  for( m = n-1; m >= 0; m--) {
    nCamb = 0;
    pxi = x;
    pxi1 = x + 1;
    pxm = x + m;
    pyi = y;
    pyi1 = y+1;

    while( pxi < pxm) {
      if( *pxi > *pxi1) {

        t = *pxi;
        *pxi++ = *pxi1;
        *pxi1++ = t;

        t = *pyi;
        *pyi++ = *pyi1;
        *pyi1++ = t;

        nCamb++;
      }
      else{
        pxi++;
        pxi1++;
        pyi++;
        pyi1++;
      }
      //printf(" dir x = %p\n", x);
      //escrVect(x, n);
    }
    //printf("fin pasada\n");
    if( nCamb == 0) return;
  }
}


//---------------------------------------------------------
//----------------------------------------------------------
double prodEsc(double *x, int saltox, double *y, int saltoy, int n)
{
  // producto escalar de dos vectores
  //
  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]

  double s = 0.0;
  double *pxi, *pyi, *pxn, *pyn;

  //printf("x: ");escrVect(x,saltox,n);printf("y: ");escrVect(y,saltoy,n);
  if( n < 0) {
    printf("prodEsc_: n negativo\n");
    return s;
  }
  if( n==0 ) return s;

  if( saltox == 1 ) {
    if( saltoy == 1) {
      // saltox = saltoy = 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) s += (*pxi++)*(*pyi++);
    }
    else{
      // saltox = 1; saltoy != 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        s += (*pxi++)*(*pyi);
        pyi += saltoy;
      }
    }
  }
  else{
    if( saltoy == 1) {
      // saltox > 1; saltoy = 1
      pyi = y;
      pyn = y + n;
      pxi = x;
      while( pyi < pyn) {
        s += (*pxi)*(*pyi++);
        pxi += saltox;
      }
    }
    else{
      // saltox != 1; saltoy != 1
      pxi = x;
      pxn = x + n*saltox;
      pyi = y;
      while( pxi < pxn) {
        s += (*pxi)*(*pyi);
        pxi += saltox;
        pyi += saltoy;
      }
    }
  }
  return s;
}

//-----------------------------------------------------------
double dist2(double *x, int saltox, double *y, int saltoy, int n)
{
  // distancia euclideana (Holder, orden 2) entre  x  y
  //
  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]

  double s = 0.0;
  double *pxi, *pyi, *pxn, *pyn, xiyi;

  if( n < 0) {
    printf("dist2_: n negativo\n");
    return s;
  }
  if( n==0) return s;

  if( saltox == 1) {
    if( saltoy == 1) {
      // saltox = saltoy = 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        xiyi = (*pxi++) - (*pyi++);
        s += xiyi*xiyi;
      }
    }
    else{
      // saltox = 1; saltoy != 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        xiyi = (*pxi++) - (*pyi);
        s += xiyi*xiyi;
        pyi += saltoy;
      }
    }
  }
  else{
    if( saltoy == 1) {
      // saltox > 1; saltoy = 1
      pyi = y;
      pyn = y + n;
      pxi = x;
      while( pyi < pyn) {
        xiyi = (*pxi) - (*pyi++);
        s += xiyi*xiyi;
        pxi += saltox;
      }
    }
    else{
      // saltox != 1; saltoy != 1
      pxi = x;
      pxn = x + n*saltox;
      pyi = y;
      while( pxi < pxn) {
        xiyi = (*pxi) - (*pyi);
        s += xiyi*xiyi;
        pxi += saltox;
        pyi += saltoy;
      }
    }
  }
  return sqrt(s);
}



//----------------------------------------------------------
void alfaX(double alfa, double *x, int salto, int n)
{
  // x = alfa * x
  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double *pxi, *pxn;

  if( n < 0) {
    printf("alfaX_: n negativo\n");
    return;
  }

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) *pxi++ *= alfa;
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      *pxi *= alfa;
      pxi += salto;
    }
  }
}


//-----------------------------------------------------------
void XMasAlfaY(double *x, int saltox, double alfa, double *y,
  int saltoy, int n)
{
  // x = x + alfa y
  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]

  // uso de apuntadores

  double *pxi, *pyi, *pxn, *pyn;

  if( n < 0) {
    printf("XMasAlfaY_: n negativo\n");
    return;
  }
  if( n==0) return;

  if( saltox == 1) {
    if( saltoy == 1) {
      // saltox = saltoy = 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) *pxi++ += alfa*(*pyi++);
    }
    else{
      // saltox = 1; saltoy != 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        *pxi++ += alfa*(*pyi);
        pyi += saltoy;
      }
    }
  }
  else{
    if( saltoy == 1) {
      // saltox > 1; saltoy = 1
      pyi = y;
      pyn = y + n;
      pxi = x;
      while( pyi < pyn) {
        *pxi += alfa*(*pyi++);
        pxi += saltox;
      }
    }
    else{
      // saltox != 1; saltoy != 1
      pxi = x;
      pxn = x + n*saltox;
      pyi = y;
      while( pxi < pxn) {
        *pxi += alfa*(*pyi);
        pxi += saltox;
        pyi += saltoy;
      }
    }
  }
}


//-----------------------------------------------------------
void XIglK(double *x, int salto, int n, double k)
{
  // x = k

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double *pxi, *pxn;

  if( n < 0) {
    printf("XIglK_: n negativo\n");
    return;
  }

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) *pxi++ = k;
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      *pxi = k;
      pxi += salto;
    }
  }
}
//-----------------------------------------------------------
void XIglY(double *x, int saltox, double *y, int saltoy, int n)
{
  // x = y

  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]

  double *pxi, *pyi, *pxn, *pyn;

  if( n < 0) {
    printf("XIglY_: n negativo\n");
    return;
  }
  if( n==0) return;

  if( saltox == 1) {
    if( saltoy == 1) {
      // saltox = saltoy = 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) *pxi++ = *pyi++;
    }
    else{
      // saltox = 1; saltoy != 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        *pxi++ = *pyi;
        pyi += saltoy;
      }
    }
  }
  else{
    if( saltoy == 1) {
      // saltox > 1; saltoy = 1
      pyi = y;
      pyn = y + n;
      pxi = x;
      while( pyi < pyn) {
        *pxi = *pyi++;
        pxi += saltox;
      }
    }
    else{
      // saltox != 1; saltoy != 1
      pxi = x;
      pxn = x + n*saltox;
      pyi = y;
      while( pxi < pxn) {
        *pxi = *pyi;
        pxi += saltox;
        pyi += saltoy;
      }
    }
  }
}
//-----------------------------------------------------------
void XIglAlfaY(double *x, int saltox, double alfa, double *y,
  int saltoy, int n)
{
  // x = alfa * y

  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]

  double *pxi, *pyi, *pxn, *pyn;

  if( n < 0) {
    printf("XIglAlfaY_: n negativo\n");
    return;
  }

  if( saltox == 1) {
    if( saltoy == 1) {
      // saltox = saltoy = 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) *pxi++ = alfa*(*pyi++);
    }
    else{
      // saltox = 1; saltoy != 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        *pxi++ = alfa*(*pyi);
        pyi += saltoy;
      }
    }
  }
  else{
    if( saltoy == 1) {
      // saltox > 1; saltoy = 1
      pyi = y;
      pyn = y + n;
      pxi = x;
      while( pyi < pyn) {
        *pxi = alfa*(*pyi++);
        pxi += saltox;
      }
    }
    else{
      // saltox != 1; saltoy != 1
      pxi = x;
      pxn = x + n*saltox;
      pyi = y;
      while( pxi < pxn) {
        *pxi = alfa*(*pyi);
        pxi += saltox;
        pyi += saltoy;
      }
    }
  }
}
//-----------------------------------------------------------
void inter(double *x, int saltox, double *y, int saltoy, int n)
{
  // intercambiar  x  y

  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]

  double *pxi, *pxn, *pyi, *pyn, t;

  if( n < 0) {
    printf("inter_: n negativo\n");
    return;
  }
  if( saltox == 1) {
    if( saltoy == 1) {
      // saltox = saltoy = 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        t = *pxi;
        *pxi++ = *pyi;
        *pyi++ = t;
      }
    }
    else{
      // saltox = 1; saltoy != 1
      pxi = x;
      pxn = x + n;
      pyi = y;
      while( pxi < pxn) {
        t = *pxi;
        *pxi++ = *pyi;
        *pyi = t;
        pyi += saltoy;
      }
    }
  }
  else{
    if( saltoy == 1) {
      // saltox > 1; saltoy = 1
      pyi = y;
      pyn = y + n;
      pxi = x;
      while( pyi < pyn) {
        t = *pxi;
        *pxi = *pyi;
        *pyi++ = t;
        pxi += saltox;
      }
    }
    else{
      // saltox != 1; saltoy != 1
      pxi = x;
      pxn = x + n*saltox;
      pyi = y;
      while( pxi < pxn) {
        t = *pxi;
        *pxi = *pyi;
        *pyi = t;
        pxi += saltox;
        pyi += saltoy;
      }
    }
  }
}
//-----------------------------------------------------------
double maxi(double *x, int salto, int n)
{
  // maximo  xi

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double *pxi, *pxn, maxi = -1.0E100, xi;

  if( n < 0) {
    printf("maxi_: n negativo\n");
    return maxi;
  }

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) {
      xi = *pxi++;
      if( xi > maxi) maxi = xi;
    }
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      xi = *pxi;
      pxi += salto;
      if( xi > maxi) maxi = xi;
    }
  }
  return maxi;
}
//-----------------------------------------------------------
double maxPos(double *x, int salto, int n, int &posi)
{
  // maximo  xi

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  // posi contendra la posicion del maximo

  double *pxi, *pxn, maxi = -1.0E100, xi;
  int i;

  if( n < 0) {
    printf("maxPos_: n negativo\n");
    return maxi;
  }
  posi = -1;
  i = 0;

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) {
      xi = *pxi++;
      if( xi > maxi) {
        maxi = xi;
        posi = i;
      }
      i++;
    }
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      xi = *pxi;
      pxi += salto;
      if( xi > maxi) {
        maxi = xi;
        posi = i;
      }
      i++;
    }
  }
  return maxi;
}
//-----------------------------------------------------------
double maxAbs(double *x, int salto, int n)
{
  // maximo  |xi|

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double *pxi, *pxn, maxi = -1.0E100, axi;

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) {
      axi = fabs(*pxi++);
      if( axi > maxi) maxi = axi;
    }
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      axi = fabs(*pxi);
      pxi += salto;
      if( axi > maxi) maxi = axi;
    }
  }
  return maxi;
}
//-----------------------------------------------------------
double minAbs(double *x, int salto, int n)
{
  // minimo  |xi|

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double *pxi, *pxn, mini = 1.0E100, axi;

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) {
      axi = fabs(*pxi++);
      if( axi < mini) mini = axi;
    }
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      axi = fabs(*pxi);
      pxi += salto;
      if( axi < mini) mini = axi;
    }
  }
  return mini;
}
//----------------------------------------------------------
double maxAbsPos(double *x, int salto, int n, int &posi)
{
  // maximo  |xi| ; indica tambien la posicion

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  // posi contendra la posicion del maximo valor abs.

  double *pxi, *pxn, maxi = -1.0E100, axi;
  int i;

  posi = -1;
  i = 0;

  if( salto == 1) {
    pxi = x;
    pxn = x + n;
    while( pxi < pxn) {
      axi = fabs(*pxi++);
      if( axi > maxi) {
        maxi = axi;
        posi = i;
      }
      i++;
    }
  }
  else{
    pxi = x;
    pxn = x + n*salto;
    while( pxi < pxn) {
      axi = fabs(*pxi);
      pxi += salto;
      if( axi > maxi) {
        maxi = axi;
        posi = i;
      }
      i++;
    }
  }
  return maxi;
}
//----------------------------------------------------------
double suma(double *x, int salto, int n)
{
  // suma de los elementos de un vector
  //
  // x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double s = 0.0;
  double *p, *pFin;

  if( n < 0) {
    printf("suma: n  negativo.\n");
    return s;
  }
  if( n == 0 ) return s;
  p = x;
  if( salto == 1 ) {
    pFin = x + n;
    while( p < pFin) s += *p++;
  }
  else{
    pFin = x + n*salto;
    while( p < pFin) {
      s += *p;
      p += salto;
    }
  }
  return s;
}
//-----------------------------------------------------------
double prod(double *x, int salto, int n)
{
  // producto de los elementos de un vector
  //
  // x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double s = 1.0;
  double *p, *pFin;

  if( n < 0) {
    printf("prod_: n  negativo.\n");
    return s;
  }
  if( n == 0 ) return s;
  p = x;
  if( salto == 1 ) {
    pFin = x + n;
    while( p < pFin) s *= *p++;
  }
  else{
    pFin = x + n*salto;
    while( p < pFin) {
      s *= *p;
      p += salto;
    }
  }
  return s;
}
//-----------------------------------------------------------
double norma2(double *x, int salto, int n)
{
  // norma euclideana de los elementos de un vector
  //
  // x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  double *p, *pFin, s = 0.0, xi;

  if( n < 0) {
    printf("norma2_: n  negativo.\n");
    return s;
  }
  if( n == 0 ) return s;

  p = x;
  if( salto == 1 ) {
    pFin = x + n;
    while( p < pFin) {
      xi = *p++;
      s += xi*xi;
    }
  }
  else{
    pFin = x + n*salto;
    while( p < pFin) {
      xi = *p;
      s += xi*xi;
      p += salto;
    }
  }
  return sqrt(s);
}
//-----------------------------------------------------------
double prom(double *x, int salto, int n)
{
  // promedio de los elementos de un vector
  //
  // x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  if( n <= 0) {
    printf("prom_: n indecuado.\n");
    return 0.0;
  }
  return suma(x, salto, n)/double(n);
}
//-----------------------------------------------------------
void ordBurb(double *x, int salto, int n)
{
  // ordena, de manera creciente, el vector  x
  // por el m\'etodo burbuja

  // x  en x[0], x[salto], x[2*salto], ..., x[(n-1)*salto]

  int nCamb, m;
  double *pxi, *pxi1, *pxm, t;

  if( n < 0) {
    printf("ordBurb_: n negativo.\n");
    return;
  }
  if( n <= 1 ) return;

  if( salto == 1) {
    for( m = n-1; m >= 0; m--) {
    nCamb = 0;
    pxi = x;
    pxi1 = x + 1;
    pxm = x + m;
    while( pxi< pxm) {
      if( *pxi > *pxi1) {
        t = *pxi;
        *pxi++ = *pxi1;
        *pxi1++ = t;
        nCamb++;
      }
      else{
        pxi++;
        pxi1++;
      }
    }
    if( nCamb == 0) return;
    }
  }
  else{
    for( m = n-1; m >= 0; m--) {
      nCamb = 0;
      pxi = x;
      pxi1 = x + salto;
      pxm = x + m*salto;
      while( pxi< pxm) {
        if( *pxi > *pxi1) {
          t = *pxi;
          *pxi = *pxi1;
          *pxi1 = t;
          nCamb++;
        }
        pxi += salto;
        pxi1 += salto;
      }
      if( nCamb == 0) return;
    }
  }
}
//-----------------------------------------------------------
void sumaXY(double *x, int saltox, double *y, int saltoy,
  double *z, int saltoz, int n)
{
  // z = x + y

  // x[0], x[saltox], x[2*saltox], ..., x[(n-1)*saltox]
  // y[0], y[saltoy], y[2*saltoy], ..., y[(n-1)*saltoy]
  // z[0], z[saltoz], z[2*saltoz], ..., z[(n-1)*saltoz]

  double *pxi, *pyi, *pzi, *pxn;

  if( n <= 0) {
    printf(" sumaXY :  n <= 0.\n");
    return;
  }

  pxi = x;
  pyi = y;
  pzi = z;
  pxn = x + saltox*n;
  while( pxi < pxn ) {
    *pzi = *pxi + *pyi;
    pxi += saltox;
    pyi += saltoy;
    pzi += saltoz;
  }
}

