//  INTERPOLACION Y APROXIMACION
//
//  interpap.h
// 

//#include <stdlib.h>
//#include <math.h>

//#include "opelvect.h"
//#include "algelin.h"
//#include "lectescr.h"



int polInterp(double *x, double *y, int nPuntos, double *p);
void prodPolMon( double *p, int n, double a);
void prodPolMon0( double *p, int n, double a, double *q);
int interpLagr( double *x, double *y, int nPuntos, double *p);

int difDiv(double *x, double *y, int nPuntos, int m);
void fescrDifDiv(FILE *arch, double *x, double *y, int nPuntos, int m);
double interpDifDiv(double *x, double *y, int nPuntos, int m, double t, 
  int mi, int k, int &indic);
int xkDifDiv(double t, double *x, int nPuntos, int m);

int difFin(double *y, int nPuntos, int m);
void fescrDifFin(FILE *arch, double x0, double h, double *y, 
  int nPuntos, int m);
double interpDifFin(double x0, double h, double *y, int nPuntos, 
  int m, double t, int mi, int k, int &indic);
int xkDifFin(double t, double x0, double h, int nPuntos, int m);

int funcInterp(double *x, double *y, int nPuntos, double *a);

void f1fn(double t, int n, double *ft);

int polAprMinCua(double *x, double *y, int m, int n, double *p);
int funAprMinCua(double *x, double *y, int m, int n, double *a);

//--------------------------------------------------------------------
int polInterp(double *x, double *y, int nPuntos, double *p)
{
  // Polinomio de interpoacion
  // Construccion por medio de la solucion del sistema de ecuaciones

  // Devuelve  1  si se construyo el polinomio de interpolacion.
  // Devuelve -1  si no hubo suficiente memoria para arreglos auxiliares.
  // Devuelve  0  si no es posible construir el polinomio
  //  (valores  xi  iguales o casi iguales).

  // p  apuntara a los coeficientes del polinomio en orden
  // creciente.
  // Debe tener por lo menos  nPuntos  posiciones

  double *a, xi, xij;
  int np, npnp, n, i, j, in;

  np = nPuntos;
  npnp = np*np;
  n = np-1;

  a = new double[npnp];
  if( a == NULL ) return -1;

  XIglY(p, y, np);
  for( i = 0; i <= n; i++) {
    in = i*np;
    a[in] = 1.0;
    xi = x[i];
    xij = xi;
    for( j = 1; j <= n; j++) {
      a[in+j] = xij;
      xij *= xi;
    }
  }
  //fprintf(AR,"A\n");fescrMatr(AR,a,np,np);
  return GaussPP(a, p, np, 1.0e-8);
}
//---------------------------------------------------------------------
void prodPolMon0( double *p, int n, double a, double *q)
{
  // Producto de un polinomio por el monomio  x - a
  // q(x) = p(x) (x - a)
  // n  es el grado del polinomio  p

  int i;

  q[0] = -a*p[0];
  q[n+1] = p[n];
  for( i = 1; i <= n; i++) q[i] = p[i-1] - p[i]*a;
}
//---------------------------------------------------------------------
void prodPolMon( double *p, int n, double a )
{
  // Producto de un polinomio por el monomio  x - a
  // p(x) <- p(x) (x - a)
  // n  es el grado inicial del polinomio  p

  int i;

  for( i = n+1; i >= 1; i--) p[i] = p[i-1];
  for( i = 1; i <= n; i++) p[i] -= a*p[i+1];
  p[0] *= -a;
}
//--------------------------------------------------------------------
int interpLagr( double *x, double *y, int nPuntos, double *p)
{
  // Polinomio de interpolacion
  // Construccion por medio de polinomios de Lagrange

  // Devuelve  1  si se construyo el polinomio de interpolacion.
  // Devuelve -1  si no hubo suficiente memoria para arreglos auxiliares.
  // Devuelve  0  si no es posible construir el polinomio
  //  (valores  xi  iguales o casi iguales).

  // p  apuntara a los coefcientes del polinomio en orden
  // creciente. Debe tener por lo menos  nPuntos  posiciones


  int i, k, nk, n;
  double *q, den;

  n = nPuntos-1;

  q = new double[nPuntos];
  if( q == NULL ) return -1;

  for( i=0; i<= n; i++) p[i] = 0.0;

  for( k = 0; k <= n; k++) {
    q[0] = 1.0;
    nk = 0;
    den = 1.0;
    for(i=0; i <= n; i++) {
      if( i != k ) {
        // fescrPol(AR, q, nk,"\nLk-1...");
        prodPolMon(q, nk, x[i]);
        nk++;
        den *= x[k] - x[i];
        /*
        fprintf(AR," xi = ");
        fescrNum(AR,x[i]);fprintf(AR,"\n");fescrPol(AR,q, nk,"Lk...");
        */
      }
    }
    //fescrPol(AR,q, nk,"\nLk~");
    if( fabs(den) <= 1.0e-20 ) return 0;

    XMasAlfaY( p, y[k]/den, q, nPuntos);
  }
  return 1;
}
//--------------------------------------------------------------------
int difDiv(double *x, double *y, int nPuntos, int m)
{
  // Sea  n  = nPuntos-1.

  // Calculo de las diferencias divididas hasta el orden  m
  // a partir de los datos

  //  x0  y0
  //  x1  y1
  //  x2  y2
  //  ...
  //  xn  yn.

  //  Se debe tener que  m <= n.

  // El arreglo  y  debe tener por lo menos  (n+1)*(m+1)
  // posiciones para almacenar las diferencia divididas.

  // A la salida, la diferencia dividida de orden j en el punto
  // xi, D^j f[xi], estara en  y[ i + j*nPuntos ],  j = 0,...,m
  //  i = 0,...,n-j
  // En algunas posiciones de  y  habra basura.

  // Devuelve  -1  si  n <= 0  o  m > n
  //  0  si hay  xi  repetidos
  //  1  si todo esta bien.

  // Los datos  xi  yi  son ordenados de manera crecientes segun  x

  int i, n, j, jn, j1n;
  double eps0 = 1.0e-16;

  n = nPuntos-1;

  if( n <= 0 || m > n ) {
    printf(" Llamado INADECUADO de  difDiv.\n");
    return -1;
  }

  ordBurbXY(x, y, nPuntos);
  //fprintf(AR,"Ordenamiento:\n");
  //fescrDifDiv(AR,x,y,nPuntos,0);

  for( i = 0; i < n; i++ ) {
    if( fabs(x[i]-x[i+1]) <= eps0*( 1.0+fabs(x[i]) ) ) {
      printf(" En  difDiv  hay  xi  repetidos.\n");
      return 0;
    }    
  }

  for( j = 1; j <= m; j++) {
    jn = j*nPuntos;
    j1n = jn - nPuntos;
    for(i=0 ;i<=n-j; i++) {
      y[i+jn] = (y[i+1+j1n]-y[i+j1n])/(x[i+j]-x[i]);
    }
  }
  //fescrDifDiv(AR,x,y,nPuntos,m);

  return 1;
}
//--------------------------------------------------------------------
void fescrDifDiv(FILE *arch, double *x, double *y, int nPuntos, int m)
{
       
  // Sea  n  = nPuntos-1.

  // Escritura en un archivo de la tabla de diferencias divididas
  // hasta las de orden  m.

  //  Se debe tener que  m <= n.

  // El arreglo  x  contiene:
  //  x0  x1  x2  x3  xn

  // El arreglo  y  tiene las diferencias divididas.

  // La diferencia dividida de orden j en el punto xi, D^j f[xi],
  // esta en  y[ i + j*nPuntos ],  j = 0,...,m
  //   i = 0,...,n-j

  //**************************
  char formato[] = " %12.6lf";
  //**************************

  int i, j, j9, n;

  n = nPuntos-1;

  for( i=0; i <= n; i++) {
    fprintf(arch, formato, x[i]);
    j9 = mini(m, n-i);
    for(j=0; j <= j9; j++) fprintf(arch, formato, y[i+j*nPuntos]);
    fprintf(arch, "\n");
  }
}
//---------------------------------------------------------------------
int xkDifDiv(double t, double *x, int nPuntos, int m)
{
  // Obtencion de  xk  con el objetivo de calcular  p(t) por
  // interpolacion por diferencias divididas
  // con un polinomio de grado <= m.

  // Sea  n = nPuntos-1.

  // El arreglo  x  tiene los valores  x0  x1  x2 ... xn.
  // Deben estar en orden creciente.

  // Esta funcion devuelve el valor  k  tal que
  //
  // | t - prom_k | = min { | t - prom_i | : i = ... },
  //
  // donde   prom_i = prom{x[i], x[i+1], ..., x[i+m]}

  // Si  m > n devuelve  -1

  int n, i, k;
  double distMin, disti;

  n = nPuntos-1;
  if( m > n ) {
    printf("xkDifDiv: m > n.\n");
    return -1;
  }
  if( t <= x[0] ) return 0;
  if( t >= x[n] ) return n;
  k = 0;
  distMin = fabs( t- prom(x, m+1) );
  for( i=1; i <= n-m; i++) {
    disti = fabs( t - prom(&x[i], m+1) );
    if( disti < distMin ) {
      distMin = disti;
      k = i;
    }
  }
  return k;
}
//---------------------------------------------------------------------
double interpDifDiv(double *x, double *y, int nPuntos, int m, double t, int mi,
  int k, int &indic)
{
  // Interpolacion por diferencias divididas.

  // Devuelve  p(t) calculado por interpolacion por diferencias divididas
  // con un polinomio de grado <= mi,
  // a partir del punto  (xk, yk).

  // Sea  n = nPuntos-1.

  // El arreglo  x  tiene los valores  x0  x1  x2 ... xn.

  // El arreglo  y  tiene las diferencias divididas hasta el orden  m

  // La diferencia dividida de orden j en el punto xi, D^j f[xi],
  // esta en  y[ i + j*nPuntos ],  j = 0,...,m
  //   i = 0,...,n-j

  // El indicador  indic  valdra  -1  si el llamado a esta funcion es
  // incorrecto:

  // Si  m < 0   o  m > n   la funcion devuelve   y[0]
  // Si  mi < 0  o  mi > m  la funcion devuelve   y[0]

  // El indicador  indic  valdra  0  si el llamado a esta funcion es
  // incorrecto:

  // Si  k < 0  la funcion devuelve   y[0]
  // Si  k > n  la funcion devuelve   y[n]

  // Si los datos estan bien, indic  valdra  1;

  int n, j;
  double pt, coef;

  n = nPuntos-1;
  if( nPuntos <= 0  ) {
    printf("interpDifDiv: nPuntos  inadecuado.\n");
    indic = -1;
    return y[0];
  }

  if( m < 0 || m > n ) {
    printf("interpDifDiv: m  inadecuado.\n");
    indic = -1;
    return y[0];
  }

  if( mi < 0 || mi > m ) {
    printf("interpDifDiv: m_i  inadecuado.\n");
    indic = -1;
    return y[0];
  }

  if( k < 0 || k > n ) {
    printf("interpDifDiv: k  inadecuado.\n");
    indic = 0;
    return y[0];
  }

  if( k > n-mi ) {
    printf("interpDifDiv: k, mi  inadecuados.\n");
    indic = 0;
    return y[n];
  }

  pt = y[k];
  coef = 1.0;
  //fprintf(AR,"xk= %lf  coef=%lf   p(t)= %lf\n",x[k],coef,pt);

  for( j = 1; j <= mi; j++) {
     coef = coef*(t-x[k+j-1]);
     pt = pt + coef*y[k+j*nPuntos];
    //fprintf(AR,"coef=%lf  D^jf[xk]=%lf  p(t)= %lf\n",coef,y[k+j*nPuntos],pt);
  }

  indic = 1;
  return pt;
}
//---------------------------------------------------------------------
int difFin(double *y, int nPuntos, int m)
{
  // Sea  n  = nPuntos-1.

  // Calculo de las diferencias finitas hasta el orden  m
  // a partir de los datos

  //  x0  y0
  //  x1  y1
  //  x2  y2
  //  ...
  //  xn  yn.

  //  Ele valor  xi  esta adefinido por   xi = x0 + i*h.
  //  Se debe tener que  m <= n.

  // El arreglo  y  debe tener por lo menos  (n+1)*(m+1)
  // posiciones para almacenar las diferencia finitas.

  // A la salida, la diferencia finita de orden j en el punto
  // xi, D^j fi, estara en  y[ i + j*nPuntos ],   j = 0,...,m
  //  i = 0,...,n-j
  // En algunas posiciones de  y  habra basura.

  // Devuelve  -1  si  n <= 0  o  m > n
  //  1  si todo esta bien.


  int i, n, j, jn, j1n;

  n = nPuntos-1;

  if( n <= 0 || m > n ) {
    printf(" Llamado INADECUADO de  difFin.\n");
    return -1;
  }

  for( j = 1; j <= m; j++) {
    jn = j*nPuntos;
    j1n = jn - nPuntos;
    for(i=0 ;i<=n-j; i++) {
       y[i+jn] = y[i+1+j1n] - y[i+j1n];
    }
  }
  //fescrDifFin(AR,x,y,nPuntos,m);

  return 1;
}
//---------------------------------------------------------------------
void fescrDifFin(FILE *arch, double x0, double h, double *y, int nPuntos, int m)
{
  // Sea  n  = nPuntos-1.
  // Escritura en un archivo de la tabla de diferencias finitas
  // hasta las de orden  m.

  //  Se debe tener que  m <= n.

  //  Los puntos xi estan definidos por   xi = x0 + i*h.

  // El arreglo  y  tiene las diferencias finitas.

  // La diferencia finita de orden j en el punto xi, D^j fi,
  // esta en  y[ i + j*nPuntos ],  j = 0,...,m
  //   i = 0,...,n-j

  //**************************
  char formato[] = " %12.6lf";
  //**************************

  int i, j, j9, n;

  n = nPuntos-1;

  for( i=0; i <= n; i++) {
    fprintf(arch, formato, x0+double(i)*h);
    j9 = mini(m, n-i);
    for(j=0; j <= j9; j++) fprintf(arch, formato, y[i+j*nPuntos]);
    fprintf(arch, "\n");
  }
}
//---------------------------------------------------------------------
double interpDifFin(double x0, double h, double *y, int nPuntos, int m, double t,
  int mi, int k, int &indic)
{
  // Interpolacion por diferencias finitas.

  // Devuelve  p(t) calculado por interpolacion por diferencias finitas
  // con un polinomio de grado <= mi,
  // a partir del punto  (xk, yk).

  // Sea  n = nPuntos-1.

  // El arreglo  x  tiene los valores  x0  x1  x2 ... xn.

  // El arreglo  y  tiene las diferencias finitas hasta el orden  m

  // La diferencia finita de orden j en el punto xi, D^j f[xi],
  // esta en  y[ i + j*nPuntos ],  j = 0,...,m
  //   i = 0,...,n-j

  // El indicador  indic  valdra  -1  si el llamado a esta funcion es
  // incorrecto:

  // Si  m < 0   o  m > n   la funcion devuelve   y[0]
  // Si  mi < 0  o  mi > m  la funcion devuelve   y[0]

  // El indicador  indic  valdra  0  si el llamado a esta funcion es
  // incorrecto:

  // Si  k < 0  la funcion devuelve   y[0]
  // Si  k > n  la funcion devuelve   y[n]

  // Si los datos estan bien, indic  valdra  1;

  int n, j;
  double pt, coef, s;

  n = nPuntos-1;
  if( nPuntos <= 0  ) {
    printf("interpDifFin: nPuntos  inadecuado.\n");
    indic = -1;
    return y[0];
  }

  if( m < 0 || m > n ) {
    printf("interpDifFin: m  inadecuado.\n");
    indic = -1;
    return y[0];
  }

  if( mi < 0 || mi > m ) {
    printf("interpDifFin: m_i  inadecuado.\n");
    indic = -1;
    return y[0];
  }

  if( k < 0 || k > n ) {
    printf("interpDifFin: k  inadecuado.\n");
    indic = 0;
    return y[0];
  }

  if( k > n-mi ) {
    printf("interpDifFin: k, mi  inadecuados.\n");
    indic = 0;
    return y[n];
  }

  pt = y[k];
  coef = 1.0;
  s = (t - (x0+double(k)*h))/h;
  //fprintf(AR,"xk= %lf  s=%lf   coef=%lf  p(t)= %lf\n",x0+double(k)*h,s,coef,pt);

  for( j = 1; j <= mi; j++) {
    coef = coef*(s-double(j-1))/double(j);
    pt = pt + coef*y[k+j*nPuntos];
    //fprintf(AR,"coef=%lf  D^jf[xk]=%lf  p(t)= %lf\n",coef,y[k+j*nPuntos],pt);
  }

  indic = 1;
  return pt;
}
//---------------------------------------------------------------------
int xkDifFin(double t, double x0, double h, int nPuntos, int m)
{
  // Obtencion de  xk  con el objetivo de calcular  p(t) por
  // interpolacion por diferencias finitas
  // con un polinomio de grado <= m.

  // Sea  n = nPuntos-1.

  // Los valores  x0  x1  x2 ... xn estan definidos por  xi = x0 + i*h.

  // Esta funcion devuelve el valor  k  tal que
  //
  // | t - prom_k | = min { | t - prom_i | : i = ... },
  //
  // donde   prom_i = (x[i] + x[i+m])/2

  // Si  m > n devuelve  -1

  int n, i, k;
  double distMin, disti, mh2;

  n = nPuntos-1;
  if( m > n ) {
    printf("xkDifFin: m > n.\n");
    return -1;
  }
  if( t <= x0 ) return 0;
  if( t >= x0 + double(n)*h ) return n;
  k = 0;
  mh2 = double(m)*h/2.0;
  distMin = fabs( t - x0 - mh2 );
  for( i=1; i <= n-m; i++) {
    disti = fabs( t - x0 - double(i)*h - mh2) ;
    if( disti < distMin ) {
      distMin = disti;
      k = i;
    }
  }
  return k;
}
//---------------------------------------------------------------------
int funcInterp(double *x, double *y, int nPuntos, double *a)
{
  // Funcion de interpoacion

  // f(x) = a1 f1(x) + a2 f2(x) + ... + an fn(x)

  // a partir de los datos

  //  x1  y1
  //  x2  y2
  //  x3  y3
  // ...
  //  xn  yn
  //   donde  n =  nPuntos.

  // Construccion por medio de la solucion del sistema de ecuaciones

  // Devuelve  1  si se construyo la funcion de interpolacion,
  //  o sea, se calcularon los coeficientes  a1  a2 ... an
  // Devuelve -1  si no hubo suficiente memoria para arreglos auxiliares.
  // Devuelve  0  si no es posible construir la funcion, matriz no invertible.


  // Los coeficientes  a1  a2  ...  an  estaran en el arreglo  a.
  // El arreglo  a  debe tener por lo menos  n  posiciones.

  // La funcion  f1fn, dado un  t,  calcula los valores  f1(t)  f2(t)  fn(t)

  double *F;
  int i, n;

  n = nPuntos;

  F = new double[n*n];
  if( F == NULL ) return -1;


  for( i = 0; i < n; i++) f1fn(x[i], n, &F[i*n] );
  //fprintf(AR,"FI\n");fescrMatr(AR,F,n,n);
  XIglY(a, y, n);
  return GaussPP(F, a, n, 1.0e-8);
}
//--------------------------------------------------------------------
void f1fn(double t, int n, double *ft)
{
  // Esta funcion deja en el arreglo  ft
  // los valores  f1(t)  f2(t)  f3(t) ... fn(t)

  int i;

  // ejemplo con polinomios

  //fit = 1.0;
  //ft[0] = 1.0;
  //for( i=2; i <= n; i++) {
  //  fit *= t;
  //  ft[i-1] = fit;
  //}

  // ejemplo con 1 exp(x) exp(2x)  ...

  ft[0] = 1.0;
  for( i=2; i <= n; i++) ft[i-1] = exp( double(i-1)*t);
}
//---------------------------------------------------------------------
int polAprMinCua(double *x, double *y, int m, int n, double *p)
{
  // Polinomio de aproximacion por minimos cuadrados.
  // Hay  m  puntos. Las coordenadas estanen los arreglos  x  y
  // n  es el grado del polinomio
  // Los n+1 coeficientes del polinomio quedaran en  p.

  // Uso de la ecuacion normal
  // Devuelve  1  si se construyo el polinomio de aproximacion.
  // Devuelve -1  si no hubo suficiente memoria para arreglos auxiliares.
  // Devuelve  0  si no es posible construir el polinomio

  // p  apuntara a los coefcientes del polinomio en orden
  // creciente.
  // Debe tener por lo menos  nPuntos  posiciones

  double *F;  // matriz con los valores  (xi)^j
  double *FF; // parte triangular superior de  Ft F
  double xi, xij;
  int n1, in, i, j,nn1;

  n1 = n+1;
  nn1 = (n1*(n1+1))/2;

  F = new double[m*n1];
  if( F == NULL ) return -1;

  FF = new double[nn1];
  if( FF == NULL ) return -1;

  for( i = 0; i < m ; i++) {
    in = i*n1;
    F[in] = 1.0;
    xi = x[i];
    xij = xi;
    for( j = 1; j <= n; j++) {
      F[in+j] = xij;
      xij *= xi;
    }
  }
  //fprintf(AR,"F\n");fescrMatr(AR,F,m,n1);
  AtATrS(F, FF, m,n1);

  //fprintf(AR,"Ft F\n");fescrVect(AR,FF,nn1);
  prodAtVect(F, y, p, m, n1);
  //fprintf(AR,"Ft y\n");fescrVect(AR,p,n1);

  return solCholTS(FF, p, n1, 1.0e-8);
}
//---------------------------------------------------------------------
int funAprMinCua(double *x, double *y, int m, int n, double *a)
{
  // Funcion de aproximacion por minimos cuadrados.

  // f(x) = a1 f1(x) + a2 f2(x) + ... + an fn(x)

  // Hay  m  puntos. Las coordenadas estan en los arreglos  x  y

  // Los n coeficientes de las funciones de la base quedaran en  a.

  // Uso de la ecuacion normal
  // Devuelve  1  si se construyo la funcion de aproximacion.
  // Devuelve -1  si no hubo suficiente memoria para arreglos auxiliares.
  // Devuelve  0  si no es posible construir la funcion

  // La funcion  f1fn, dado un  t,  calcula los valores  f1(t)  f2(t)  fn(t)


  double *F;  // matriz con los valores  (xi)^j
  double *FF; // parte triangular superior de  Ft F
  int i, nn2;

  nn2 = (n*(n+1))/2;

  F = new double[m*n];
  if( F == NULL ) return -1;

  FF = new double[nn2];
  if( FF == NULL ) return -1;

  for( i = 0; i < m; i++) f1fn(x[i], n, &F[i*n] );

  //fprintf(AR,"F\n");fescrMatr(AR,F,m,n);
  AtATrS(F, FF, m, n);

  //fprintf(AR,"Ft F\n");fescrVect(AR,FF,nn2);
  prodAtVect(F, y, a, m, n);
  //fprintf(AR,"Ft y\n");fescrVect(AR,a,n);

  return solCholTS(FF, a, n, 1.0e-8);
}
