//  INTEGRACION NUMERICA

//  integr.h


#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "varios.h"
#include "opelvect.h"




double Simpson(double (*f)(double x), double a, double b, 
               int nSubint, int &indic);

double Simpson(double *y, int nVal, double b_a, int &indic);

double Simpson(double (*f)(double x), double a, double b, 
               double eps, int &indic, double &nEval);

void GaussLegXW0(int n, double *x, double *w);

void GaussLegXW1(int n, double *x, double *w, double eps0);

void GaussLegXW(int n, double *x, double *w);

double GaussLeg(double (*f)(double x), double a, double b, 
                int n, double *x, double *w);

double GaussLeg(double (*f)(double x), double a, double b, 
                int n);

double GaussLeg2(double (*f)(double x), double a, double b, 
                 int n, int nSubint, double *x, double *w);

double GaussLeg2(double (*f)(double x), double a, double b, 
                 int n, int nSubint);

double GaussLegIter(double (*f)(double x), double a, double b, 
                    int n, double eps, int &indic);



//----------------------------------------------------------
double f1(double x)
{
  // ejemplo de funcion  f
  
  return exp(-x*x);
  //return x*x*x+2;
}
//----------------------------------------------------------
double Simpson(double (*f)(double x), double a, double b, 
               int nSubint, int &indic)
{
  // Integracion numerica, formula de Simpson
  // El primer parametro es la funcion  f
  // La funcion  f  devuelve  f(x).

  // nSubint = numero de subintervalos

  // Sea  n = nSubint.

  // El caso ideal es que  n >= 2  y  par.
  // Si  n >= 2  e impar  se utiliza en una parte la formula de Simpson
  // obtenida por interpolacion cubica.

  // Devuelve el valor aproximado de la integral

  // indic  valdra:
  //      -1  si  nSubint < 0
  //       0  si  nSubint = 0, 1
  //       1  en los demas casos

  int n, m, k, j;
  double s = 0.0, s3 = 0.0, s1, s2, h, hh, b1, xi;

  indic = 1;
  n = nSubint;

  if( nSubint < 0 ) {
    printf(" Simpson: nSubint = %d  ERRONEO.\n", nSubint);
    indic = -1;
    return 0.0;
  }
  if( nSubint == 0 ) {
    printf(" Simpson: 0 subintervalos.\n");
    indic = 0;
    return (b-a)*f( (a+b)/2.0 );
  }
  h = (b-a)/double(n);
  if( nSubint == 1 ) {
    printf(" Simpson: 1 solo subintervalo.\n");
    indic = 0;
    return (f(a)+f(b))*h/2.0;
  }
  hh = h+h;
  if( n%2 == 1 ) {
     b1 = b-hh-h;
     m = n-3;
     s3 = h*(f(b1) + 3.0*(f(b1+h)+f(b1+hh))+ f(b))*3.0/8.0;
     //printf( " s3 = %lf\n", s3);
  }
  else{
    m = n;
    b1 = b;
  }
  k = m/2;
  //printf( " m = %d  k = %d\n",m,k);
  if( m > 0 ) s = f(a) + f(b1);

  // impares
  s1 = 0.0;
  xi = a+h;
  for( j = 1; j <= k; j++ ) {
    s1 += f(xi);
    xi += hh;
  }

  // pares
  s2 = 0.0;
  xi = a+hh;
  for( j = 1; j <= k-1; j++ ) {
    s2 += f(xi);
    xi += hh;
  }

  //printf( " s1 = %lf  s2 = %lf\n",s1,s2);

  s += 4.0*s1 + 2.0*s2;
  s *= h/3.0;
  s += s3;
  return s;
}
//----------------------------------------------------------
double Simpson(double *y, int nVal, double b_a, int &indic)
{
  // Integracion numerica, formula de Simpson
  // Hay  nVal  valores  yi, es decir, n = nVal-1  subintervalos.
  // El caso ideal es que  n >= 2  y  par.
  // Si  n >= 2  e impar  se utiliza en una parte la formula de Simpson
  // obtenida por interpolacion cubica.

  // b_a es la longitud del intervalo = b-a

  // Devuelve el valor aproximado de la integral

  // indic  valdra:
  //      -1  si  nVal < 0
  //       0  si  nVal = 1, 2  o  h <= 0
  //       1  en los demas casos

  int n, m, k;
  double s = 0.0, s3 = 0.0, s1, s2, h;

  indic = 1;
  n = nVal-1;

  if( nVal <= 0 ) {
    printf(" Simpson: nVal = %d  ERRONEO.\n", nVal);
    indic = -1;
    return 0.0;
  }
  if( b_a <= 0.0 ) {
    printf(" Simpson: b-a = %lf  no es positivo.\n", b_a);
    indic = 0;
  }

  //int i;printf("y: ");for(i=0;i<nVal;i++)printf("%lf ",y[i]);printf("\n");
  if( nVal == 1 ) {
    printf(" Simpson: 1 solo valor  yi.\n");
    indic = 0;
    return y[0]*b_a;
  }

  h = b_a/double(n);
  if( nVal == 2 ) {
    printf(" SimpsonVal: 2  valores  yi.\n");
    indic = 0;
    return (y[0]+y[1])*h/2.0;
  }

  if( n%2 == 1 ) {
    m = n-3;
    s3 = h*(y[m] + 3.0*(y[n-2]+y[n-1])+ y[n])*3.0/8.0;
    //printf(" s3 = %lf\n", s3);
  }
  else m = n;

  k = m/2;
  //printf(" m = %d  k = %d\n",m,k);

  if( m > 0 ) s = y[0] + y[m];

  // impares
  s1 = 0.0;
  //for( j = 1; j <= k; j++ ) s1 += y[2*j-1];
  if( k > 0 ) s1 = suma( &y[1], 2, k);

  // pares
  s2 = 0.0;
  if( k > 1 ) s2 = suma( &y[2], 2, k-1);
  //printf(" s1 = %lf  s2 = %lf\n",s1,s2);

  s += 4.0*s1 + 2.0*s2;
  s *= h/3.0;
  s += s3;
  return s;
}
//----------------------------------------------------------
double Simpson(double (*f)(double x), double a, double b, 
               double eps, int &indic, double &nEval)
{
  double int0, int1, s2, s1, sab, h, xi, h2, difRel, n;
  int maxit, k;

  // Metodo de Simpson iterativo para hallar la integral
  // en el intevalo  (a,b), de la funcion definida en   f
  // Empieza en 4 subintervalos y va duplicando el numero
  // hasta convergencia, o sea cuando
  // | int(2n) - int(n) |/(| int(2n) | + 1 ) <= eps

  // Si todo funciona bien  indic valdra  1.
  // Valdra  0   en caso contrario
  // (muchas iteraciones sin obtener convergencia).

  // nEval   indicara el numero de evaluaciones de la funcion.
  //         Teoricamente es un entero, pero, en esta funcion,
  //         es doble precision para pemitir valores muy grandes.

  maxit = 20;

  sab = f(a)+f(b);

  n = 2;
  h = (b-a)/2.0;
  s2 = 0.0;
  s1 = f(a+h);
  int0 = h*(sab+4.0*s1)/3.0;


  n = 4;
  h /= 2.0;
  s2 += s1;
  s1 = f(a+h) + f(b-h);
  int1 = h*(sab + 4.0*s1 + 2.0*s2)/3.0;
  nEval = 5;

  //printf("    2  %30.16lf\n", int0);
  //printf("    4  %30.16lf\n", int1);
  k = 1;
  indic = 1;
  while( k <= maxit ) {
    k++;

    difRel = fabs(int0-int1)/(1.0+fabs(int1));
    if( difRel <= eps ) return int1;

    h2 = h;
    h /= 2.0;

    nEval += n;
    n *= 2.0;

    s2 += s1;
    s1 = 0.0;

    for( xi = a+h; xi <= b; xi += h2 ) s1 += f(xi);

    int0 = int1;
    int1 = h*(sab + 4.0*s1 + 2.0*s2)/3.0;
    //printf(" %8.0lf  %30.16lf\n", n, int1);
  }
  indic = 0;
  return int1;
}
//----------------------------------------------------------
void GaussLegXW0(int n, double *x, double *w)
{
  // Abcisas y pesos  para la cuadratura de Gauss-Legendre.

  // Tomados de tablas

  int nMax = 6;

  if( n <= 0 ) {
    printf(" GaussLegXW: n <= 0.\n");
    //x[0] = 0.0;
    //w[0] = 2.0;
    return;
  }
  if( n > nMax ) {
    printf(" GaussLegXW: n = %d > nMax = %d 0.\n", n, nMax);
    n = nMax;
  }

  switch(n) {
    case 1:
      x[0] =  0.000000000000000;  w[0]= 2.000000000000000;
      break;
    case 2:
      x[0] = -0.577350269189626;  w[0]= 1.000000000000000;
      x[1] =  0.577350269189626;  w[1]= 1.000000000000000;
      break;
    case 3:
      x[0] = -0.774596669241483;  w[0]= 0.555555555555553;
      x[1] =  0.000000000000000;  w[1]= 0.888888888888889;
      x[2] =  0.774596669241483;  w[2]= 0.555555555555553;
      break;
    case 4:
      x[0] = -0.861136311594053;  w[0]= 0.347854845137454;
      x[1] = -0.339981043584856;  w[1]= 0.652145154862546;
      x[2] =  0.339981043584856;  w[2]= 0.652145154862546;
      x[3] =  0.861136311594053;  w[3]= 0.347854845137454;
      break;
    case 5:
      x[0] = -0.906179845938664;  w[0]= 0.236926885056189;
      x[1] = -0.538469310105683;  w[1]= 0.478628670499366;
      x[2] =  0.000000000000000;  w[2]= 0.568888888888889;
      x[3] =  0.538469310105683;  w[3]= 0.478628670499366;
      x[4] =  0.906179845938664;  w[4]= 0.236926885056189;
      break;
    case 6:
      x[0] = -0.932469514203152;  w[0]= 0.171324492379170;
      x[1] = -0.661209386466264;  w[1]= 0.360761573048139;
      x[2] = -0.238619186083197;  w[2]= 0.467913934572691;
      x[3] =  0.238619186083197;  w[3]= 0.467913934572691;
      x[4] =  0.661209386466264;  w[4]= 0.360761573048139;
      x[5] =  0.932469514203152;  w[5]= 0.171324492379170;
      break;
    default:
      printf(" GaussLegXW0: RARISIMO.\n");
      return;
  }
} 


//----------------------------------------------------------
void GaussLegXW1(int n, double *x, double *w, double eps0)
{
  // Calculo de las abcisas y de los pesos  para la cuadratura de
  // Gauss- Legendre

  // adaptado de la version Fortran del libro
  // Press et al., Numerical Recipes,
  // Cambridge U. Press, Cambridge, 1986, pag 125-126

  double p1, p2, p3, J, N, z1, z, N5, pp;
  int m, n1, ni, i, j, i1, k;


  //*****************  
  int maxit = 10;
  //*****************

  if( n <= 0 ) {
     printf(" GaussLegXW: n <= 0.\n");
     //x[0] = 0.0;
      //w[0] = 2.0;
      return;
  }

  n1 = n+1;
  m = n1/2;
  N = n;
  N5 = N+0.5;

  for( i=1; i <= m; i++) {
    i1 = i-1;
    ni = n-i;
    z = cos(3.14159265358979*(i-0.25)/N5);
    k = 0;
    do{
      p1 = 1.0;
      p2 = 0.0;
      for( j=1; j <= n; j++) {
        J = j;
        p3 = p2;
        p2 = p1;
        p1 = ((2.0*J-1.0)*z*p2-(J-1.0)*p3)/J;
      }
      pp = N*(z*p1-p2)/(z*z-1.0);
      z1 = z;
      z = z1-p1/pp;
      k++;
    } while ( fabs(z-z1) > eps0 && k <= maxit );
    if(k>maxit)printf("GaussLegXW1: RARO: %d iter.  z-z1=%e\n",k,z-z1);
    //printf("%d ", k);
    x[i1] = -z;
    x[ni] =  z;
    w[i1] = 2.0/((1.0-z*z)*pp*pp);
    w[ni] = w[i1];
  }
}
//----------------------------------------------------------
void GaussLegXW(int n, double *x, double *w)
{
  // Obtencion de las abcisas y de los pesos  para la cuadratura de
  // Gauss- Legendre

  // para valores pequenos se toman de tablas
  // para valores grandes se calculan numericamente

  // x, w  deben tener espacio para almacenar  n  numeros

  //**********************
  double eps0 = 1.0e-15; 
  //***********************

  if( n <= 0 ) {
    printf(" GaussLegXW: n <= 0.\n");
    return;
  }

  if( n <= 6 ) GaussLegXW0(n, x, w); 
  else GaussLegXW1(n, x, w, eps0); 
}
//----------------------------------------------------------
double GaussLeg(double (*f)(double x), double a, double b, 
                int n, double *x, double *w)
{
  // Cuadratura de Gauss Legendre
  // en el intervalo  [a, b].
  // n = numero de puntos para la cuadratura
  // Los valores  xi  wi  vienen en los arreglos  x,  w.

  double s = 0.0, c1, c2;
  int i;

  if( n <= 0 ) {
    printf(" GaussLeg: ERROR: n <= 0\n\n");
    return 0.0;
  }

  c1 = (b-a)/2.0;
  c2 = (b+a)/2.0;
  for( i =0; i < n; i++) s += w[i]*f( c1*x[i] + c2 );
  s *= c1;
  return s;
}
//----------------------------------------------------------
double GaussLeg(double (*f)(double x), double a, double b, 
                int n)
{
  // Cuadratura de Gauss Legendre
  // en el intervalo  [a, b].
  // n = numero de puntos para la cuadratura
  // Dentro de la funcion se hace un llamado para obtener x w

  double s;
  double *x, *w;

  if( n <= 0 ) {
    printf(" GaussLeg: ERROR: n <= 0\n\n");
    return 0.0;
  }

  x = new double[n];  w = new double[n];
  if( x == NULL || w == NULL ){
    printf("GaussLeg: RARO: memoria insuficiente.\n");
    return 0.0;
  }

  GaussLegXW(n, x, w);
  s = GaussLeg(f, a, b, n, x, w);

  delete x;  delete w;

  return s;
}
//----------------------------------------------------------
double GaussLeg2(double (*f)(double x), double a, double b, 
                 int n, int nSubint, double *x, double *w)
{
  // Cuadratura de Gauss Legendre
  // n = numero de puntos para la cuadratura
  // El intervalo  [a, b] se divide en  nSubint  subintervalos

  // Los valores  xi  wi  estan en los arreglos  x   w

  // Utiliza  GaussLeg

  double s = 0.0, ai, bi, h;

  int i;

  if( n <= 0 ) {
    printf(" GaussLegSubi: ERROR: n <= 0\n\n");
    return 0;
  }

  if( nSubint <= 0 ) {
    printf(" GaussLegSubi: nSubint  <= 0.\n");
    return 0.0;
  }
  h = (b-a)/nSubint;
  //ai = a;
  //bi = a+h;
  for( i = 1; i <= nSubint; i++) {
    bi = a + i*h;
    ai = bi-h;
    s += GaussLeg(f, ai, bi, n, x, w);
    //ai = bi;
    //bi +=h;
  }
  return s;
}
//----------------------------------------------------------
double GaussLeg2(double (*f)(double x), double a, double b, 
                 int n, int nSubint)
{
  // Cuadratura de Gauss Legendre
  // n = numero de puntos para la cuadratura
  // El intervalo  [a, b] se divide en  nSubint  subintervalos

  // Dentro de la funcion se hace un llamado para obtener x w

  // Utiliza  GaussLeg

  double s, *x, *w;

  if( n <= 0 ) {
    printf(" GaussLeg2: ERROR: n <= 0\n\n");
    return 0;
  }

  if( nSubint <= 0 ) {
    printf(" GaussLeg: nSubint  <= 0.\n");
    return 0.0;
  }

  x = new double[n];  w = new double[n];
  if( x == NULL || w == NULL ){
    printf("GaussLeg: RARO: memoria insuficiente.\n");
    return 0.0;
  }

  GaussLegXW(n, x, w);
  s = GaussLeg2(f, a, b, n, nSubint, x, w);

  delete x;  delete w;

  return s;
}
//----------------------------------------------------------
double GaussLegIter(double (*f)(double x), double a, double b, 
                    int n, double eps, int &indic)
{
  double int0, int1, difRel, *x, *w;
  int maxit, k;
  int nSubint;

  // Metodo de cuadratura de Gauss-Legendre para hallar la integral
  // en el intevalo  (a,b), de la funcion definida en   f
  // Empieza en 1 subintervalo y va duplicando el numero de subintervalos
  // hasta convergencia, o sea cuando
  // | int(2n) - int(n) |/(| int(n) | + 1 ) <= eps

  // n  es el orden de la cuadratura de Gauss-Legendre usada.

  // Si todo funciona bien  indic valdra  1.
  // Valdra  0   en caso contrario
  // (muchas iteraciones sin obtener convergencia).

  maxit = 20;

  x = new double[n];
  w = new double[n];
  GaussLegXW(n, x, w);

  nSubint = 1;
  int0 = GaussLeg2(f, a, b, n, nSubint, x, w);

  nSubint = 2;
  int1 = GaussLeg2(f, a, b, n, nSubint, x, w);

  //printf("   1  %30.16lf\n", int0);
  //printf("   2  %30.16lf\n", int1);
  k = 2;
  indic = 1;
  while( k <= maxit ) {
    k++;
    difRel = fabs(int0-int1)/(1.0+fabs(int1));
    if( difRel <= eps ) return int1;
    nSubint *= 2;
    int0 = int1;
    int1 = GaussLeg2(f, a, b, n, nSubint, x, w);
    //printf(" %3d  %30.16lf\n", nSubint, int1);
  }
  indic = 0;
  return int1;
}

//----------------------------------------------------------
