//  ALGEBRA LINEAL
//
//  algelin.h

// NECESITA:

//#include<stdio.h>
//#include<math.h>
//#include<stdlib.h>

//#include "varios.h"
//#include "opelvect.h"


void sumaMatr(double *a, double *b, double *c, int m, int n);
void prodMatr(double *a, double *b, double *c, int m, int n, int q);
void prodMatr1(double **a,double **b,double **c,int m,int n,int p);

void AtA(double *a, double *b, int m, int n);
void AtATrS(double *a, double *b, int m, int n);

void prodMatrVect(double *a, double *x, double *y, int m, int n);
void prodAtVect(double *a, double *x, double *y, int m, int n);
void matrSTSVect(double *a, double *x, double *y, int n);

double **creaMatr( int m, int n);
double **creaMatr1( int m, int n);

double maxAbsTrSup( double *a, int n);

int solTrSup(double *a, double *b, int n, double eps);

int GaussPP(double *a, double *b, int n, double eps);

int matrEscRed(double *a, int m, int n, double eps);
int matrEsc(double *a, int m, int n, double eps);

int PALU( double *a, int n, double eps, int *p, double &det);
int solPALU(double *a, double *b, int *p, int n, double eps);
int GaussPALU( double *a, double *b, int n, double eps, int *p);

int tridiag(double *d, double *f, double *u, double *b, int n, 
            double eps);

double det(double *a, int n, double eps = 1.0E-15);

int solChol(double *a, double *b, int n, double eps);
int factChol(double *a, int n, double eps);
void solUty(double *u, double *b, int n);

int solChol0(double *a, double *b, int n, double eps);
int factChol0(double *a, int n, double eps);
void solUty0(double *u, double *b, int n);

int solCholTS(double *a, double *b, int n, double eps );
int factCholTS(double *a, int n, double eps);
int solUtybTS(double *u, double *b, int n, double eps);
int solUxyTS(double *u, double *y, int n, double eps);

int PALU_f(double *a, int n, double eps, int *p);
int PALU1_n(double **a, int n, int *p, double eps);
int PALU1_g(double **a, int n, int *p, double eps);
int PALU_g( double **a, int n, int *p, double eps);
int PALU_g( double  *a, int n, int *p, double eps);

int inversa_f(double *a, int n, double eps);

int inversa1(double **a, int n,  double eps);
int inversa( double **a, int n,  double eps);
int inversa( double  *a, int n,  double eps);
int inversa1_x(double **a, int n,  double eps, double **a1);

void lubksb1(double **a, int n, int *p, double *b);


//==========================================================

//----------------------------------------------------------
double **creaMatr( int m, int n)
{
  // asigna dinamicamente memoria para una matriz  m x n
  // m >= 1,  n >= 1
  // devuelve un valor de apuntador a apuntador (apuntador doble)
  //   tipo  double (doble precision)

  double **p;
  int i;

  p = new double *[m] ;
  if( p == NULL ) return( NULL);

  for( i=0; i<m; i++) {
    p[i] = new double[n];
    if( p[i] == NULL) return( NULL);
  }
  return p;
}
//----------------------------------------------------------
double maxAbsTrSup( double *a, int n)
{
  // maximo valor absoluto de un matriz triangular superior

  // A almacenada en un arreglo unidimensional,
  // Aij  esta en  a[i*n+j].

  // Trabaja unicamente con la parte triangular superior,
  // no verifica si la parte inferior es nula.

  double vi, vmax = -1.0E100;
  int i, n1;

  if( n <= 0 ) {
    printf(" maxAbsTriS:  n  NO postivo.\n");
    return vmax;
  }
  n1 = n+1;
  for( i = 0; i < n; i++ ) {
    vi = maxAbs( &a[i*n1], n-i);
    if( vi > vmax ) vmax = vi;
  }
  return vmax;
}

//----------------------------------------------------------

int solTrSup(double *a, double *b, int n, double eps)
{
  // Solucion del sistema triangular superior
  //   A x = b.

  // A almacenada en un arreglo unidimensional,
  // Aij  esta en  a[i*n+j].

  // Devuelve  1  si se resolvio el sistema.
  //     0  si la matriz es singular o casi.
  //    -1  si  n  es inadecuado
  //
  // Cuando hay solucion, esta quedara en  b.

  // A se considera singular si
  // |Aii| <= eps*( max{|Aij|} + 1) para algun i.

  // Trabaja unicamente con la parte triangular superior,
  // no verifica si la parte inferior es nula.

  int i, ii, n1, n_1;

  double epsRel;

  if( n <= 0) {
    printf(" solTrSup: valor de n <= 0.\n");
    return -1;
  }

  epsRel = maxAbsTrSup(a, n)*eps;

  n1 = n+1;
  n_1 = n-1;
  for( i = n_1; i >= 0; i--) {
    ii = i*n1;
    if( fabs( a[ii]) <= epsRel ) return 0;
    b[i] = (b[i] - prodEsc( &a[ii+1], &b[i+1], n_1-i))/a[ii];
  }
  return 1;
}
//------------------------------------------------
void prodMatr(double *a, double *b, double *c, int m, int n, int q)
{
  // producto de dos matrices, A  m x n,  B  n x q

  // Las matrices estan almacenadas en "vectores"
  // el producto se hace por medio de apuntadores
  // Utiliza  prodEsc_

  double *cij; // apuntador a  Cij
  double *cmq; // apuntador a la direccion de c[m*q]
  double *ciq; // apunt. a  C(i+1,0) : c[i*q]
  double *ai0; // apuntador a  Ai0
  double *b0j; // apuntador a  B(0,j)

  if( m <= 0 ||  n <= 0 || q <= 0 ) {
    printf(" prodMatr: uno de los tama~nos  NO es postivo.\n");
    return;
  }
  cij = c;
  cmq = c+m*q;
  ai0 = a;
  while( cij < cmq) {
    ciq = cij + q;
    b0j = b;
    while( cij < ciq) {
      *cij = prodEsc(ai0, 1, b0j, q, n);
      cij++;
      b0j++;
    }
    ai0 += n;
  }
}
//----------------------------------------------------------
void prodMatrVect(double *a, double *x, double *y, int m, int n)
{
  // producto matriz por vector :  y = A x

  // A  esta almacenada en un "vector"

  // Utiliza:  prodEsc

  double *py, *pyFin;
  int i0;

  if( m <= 0 ||  n <= 0 ) {
    printf(" prodMatrVect: uno de los tama~nos  NO es postivo.\n");
    return;
  }
  py = y;
  pyFin = py+m;

  i0 = 0;
  while( py < pyFin) {
    *py++ = prodEsc( &a[i0], x, n);
    i0 += n;
  }
}
//----------------------------------------------------------
void prodAtVect(double *a, double *x, double *y, int m, int n)
{
  // producto At por vector :  y = At x

  // A  esta almacenada en un "vector"

  // A  es de tamano  m x n
  // x  tiene  m  componentes
  // y  tendra  n  componentes

  // Utiliza:  prodEsc_

  double *py, *pyFin;
  int i;

  if( m <= 0 ||  n <= 0 ) {
    printf(" prodMatrVect: uno de los tama~nos  NO es postivo.\n");
    return;
  }
  py = y;
  pyFin = py+n;

  i = 0;
  while( py < pyFin) {
    *py++ = prodEsc( &a[i], n, x, 1, m);
    i++;
  }
}
//----------------------------------------------------------
void matrSTSVect(double *a, double *x, double *y, int n)
{
  // producto matriz simetrica por vector :  y = A x

  // A  esta almacenada en un "vector"
  // Esta almacenada unicamente la parte  triangular superior
  // A11 A12 ... A1n A22 A23 ... A2n A33 ... A3n ... Ann

  //        Aij  <--> a[ij],  ij = i*n - (i*i+i)/2 + j;
  //        Aii  <--> a[i],  ii = i*n - (i*i-i)/2;

  int i, j, ii;
  double aij;

  if( n <= 0 ) {
    printf(" matrSTSVect:  n <= 0.\n");
    return;
  }
  for( i = 0; i<n; i++) y[i] = 0.0;
  for( i = 0; i<n; i++) {
    ii = i*n-(i*i-i)/2;
    y[i] += a[ii]*x[i];
    for( j = i+1; j < n; j++) {
      //ij = ii + (j-i);
      aij = a[ii+j-i];
      y[i] += aij*x[j];
      y[j] += aij*x[i];
    }
  }
}
//----------------------------------------------------------
void sumaXY(double *a, double *b, double *c, int m, int n)
{
  // suma de dos matrices, A   B

  // Las matrices estan almacenadas en "vectores"
  // Utiliza  sumaXY

  if( m <= 0 ||  n <= 0 ) {
    printf(" sumaXY: uno de los tama~nos  NO es postivo.\n");
    return;
  }
  sumaXY(a, b, c, m*n);
}
//----------------------------------------------------------
int matrEscRed(double *a, int m, int n, double eps)
{
  // Matriz escalonada reducida por filas
  //
  // Devuelve  -1 si n <= 0
  //     rango

  // A esta almcenada por filas en  a


  int i, j, ki, k, ij, ii, iij, ij1, n_1, rango;
  double aij, aaij, epsRel, coef;

  if( m <= 0 || n <= 0 ) {
    printf(" matrEscRed:  n <= 0.\n");
    return -1;
  }
  epsRel = maxAbs(a, m*n)*eps;

  n_1 = n-1;
  i = 0;
  j = 0;
  rango = 0;
  while( i< m && j < n) {
    // printf("\n i, j : %d   %d\n", i+1, j+1);
    ij = i*n+j;
    maxAbsPos( &a[ij], n, m-i, ki);
    k = i+ki;
    // printf(" ki = %d\n", ki);
    // printf(" k_dom = %d\n", k+1);
    if( k != i ) {
      inter( &a[ij], &a[k*n+j], n-j);
      // printf(" intercambio filas  %d %d \n", i+1, k+1);
      // escrMatr(a,m,n);
    }
    aij = a[ij];
    aaij = fabs(aij);
    if( aaij > epsRel ) {
      rango++;
      a[ij] =1.0;
      coef = 1.0/aij;
      alfaX( coef, &a[ij+1], n_1-j);
      ij1 = ij+1;
      // printf(" dividir por  %lf\n", aij);
      // escrMatr(a,m,n);
      for( ii = 0; ii < m; ii++) {
        if( ii != i ) {
          iij = ii*n+j;
          coef = -a[iij];
          a[iij] = 0.0;
          XMasAlfaY( &a[iij+1], coef, &a[ij1], n_1-j);
          // printf(" 0 en  (%d, %d)\n", ii+1, j+1);
          // printf(" F%d = F%d + %lf F%d\n", ii+1, ii+1, coef, i+1);
          // escrMatr(a,m,n);
        }
      }
      i++;
      j++;
    }
    else{
      a[ij] = 0.0;
      j++;
    }
  } // end while
  return rango;
}
//----------------------------------------------------------
int matrEsc(double *a, int m, int n, double eps)
{
  // Matriz escalonada por filas
  //
  // Devuelve  -1 si n <= 0
  //           rango

  // A esta almcenada por filas en  a

  int i, j, ki, k, ij, ii, iij, ij1, n_1, rango;
  double aij, aaij, epsRel, coef;

  if( m <= 0 || n <= 0 ) {
    printf(" matrEsc:  n <= 0.\n");
    return -1;
  }
  epsRel = maxAbs(a, m*n)*eps;

  n_1 = n-1;
  i = 0;
  j = 0;
  rango = 0;
  while( i< m && j < n) {
    // printf("\n i, j : %d   %d\n", i+1, j+1);
    ij = i*n+j;
    maxAbsPos( &a[ij], n, m-i, ki);
    k = i+ki;
    // printf(" ki = %d\n", ki);
    // printf(" k_dom = %d\n", k+1);
    if( k != i ) {
      inter( &a[ij], &a[k*n+j], n-j);
      // printf(" intercambio filas  %d %d \n", i+1, k+1);
      // escrMatr(a,m,n);
    }
    aij = a[ij];
    aaij = fabs(aij);
    if( aaij > epsRel ) {
      rango++;
      ij1 = ij+1;
      for( ii = i+1; ii < m; ii++) {
        iij = ii*n+j;
        coef = -a[iij]/aij;
        a[iij] = 0.0;
        XMasAlfaY( &a[iij+1], coef, &a[ij1], n_1-j);
        // printf(" 0 en  (%d, %d)\n", ii+1, j+1);
        // printf(" F%d = F%d + %lf F%d\n", ii+1, ii+1, coef, i+1);
        // escrMatr(a,m,n);
      }
      i++;
      j++;
    }
    else{
      a[ij] = 0.0;
      j++;
    }
  } // end while
  return rango;
}
//----------------------------------------------------------
int GaussPP( double *a, double *b, int n, double eps)
{
  // Metodo de Gauss CON PIVOTEO parcial
  // para resolver  A x = b.

  // Intercambio real de las filas.

  // A almacenada en un arreglo unidimensional,
  // Aij  esta en  a[i*n+j].

  // Devuelve  1  si se resolvio el sistema.
  //           0  si la matriz es singular o casi.
  //          -1  si  n  es inadecuado

  // Cuando hay solucion, esta quedara en  b.

  int k, i, n1, ik, n_1, kk, m, m0, nn;
  double lik, aamk, t, epsRel;

  if( n <= 0 ) return -1;

  n1 = n+1;
  n_1 = n-1;
  nn = n*n;
  epsRel = maxAbs(a, nn)*eps;

  //printf("A b:\n");escrAb(a,n,n,b);
  // triangularizacion

  for( k = 0; k < n_1; k++) {
    //printf("\n\n k real = %d\n",k+1);
    kk = k*n1;
    aamk = maxAbsPos( &a[kk], n, n-k, m0);
    if( aamk <= epsRel ) return 0;
    if( m0 != 0 ) {
      m = k+m0;
      inter( &a[kk], &a[m*n+k], n-k);
      t = b[k]; b[k] = b[m]; b[m] = t;
      //inter( b[k], b[m] );
      //printf("inter: F%d  F%d\n",k+1,m+1);escrAb(a,n,n,b);
    }
    for( i = k+1; i < n; i++) {
      // anular  Aik
      ik = i*n + k;
      lik = a[ik]/a[kk];
      XMasAlfaY( &a[ik+1], -lik, &a[kk+1], n_1-k);
      b[i] -= lik*b[k];
      a[ik] = 0.0;
    }
    //printf("\n A b:\n");escrAb(a,n,n,b);
  }
  if( fabs(a[nn-1]) <= epsRel) return 0;

  solTrSup(a, b, n, eps);
  return 1;
}
//----------------------------------------------------------
int PALU( double *a, int n, double eps, int *p, double &det)
{
  // Factorizacion  PA = LU

  // Esquema presentado en Golub, Matrix Computations, pag. 112

  // La matriz  A  esta almacenada por filas en  a.

  // A la salida, en el arreglo  a  esta  U  en la posicion correspondiente,
  // Mediante la parte inferior de  a  y de  p  se puede obtener  L.

  // El apuntador  p , debe tener por lo menos  n-1  posiciones.
  // A la salida tiene informacion sobre los intercambios de filas

  // Devuelve  -1  si  n  es inadecuado
  //            0  si  A  es singular o casi.
  //            1  si  A  es regular.

  // Tambien calcula el determinante:  det

  // Utiliza: maxAbs
  //          maxAbsPos_
  //          inter
  //          alfaX_
  //          XMAsAlfaY
  //          prod_

  int n_1, k, n1, mk, kk, m, ik, i, signo = 1;
  double vamax, epsRel, coef;

  det = 0.0;

  if( n <= 0 ) {
    printf(" PALU:  n  <= 0.\n");
    return -1;
  }
  // fprintf(AR, " ... %lf %d\n", eps, p[0]);
  n_1 = n-1;
  n1 = n+1;
  epsRel = eps*maxAbs(a, n*n);
  // fprintf(AR, " epsRel = %e\n", epsRel);
  for( k =0; k < n_1; k++) {
    kk = k*n1;
    vamax = maxAbsPos( &a[kk], n, n-k, mk);
    m = k+mk;
    p[k] = m;
    // fprintf(AR, "\n k = %d,  vamax = %lf  m = %d\n", k+1, vamax, m+1);
    if( vamax <= epsRel ) return 0;
    if( k != m ) {
      signo = -signo;
      inter(&a[kk], &a[m*n+k], n-k);
      // fprintf(AR, " intercambio de parte de las filas %d %d\n",k+1,m+1);
      // fescrMatr(AR,a,n,n);
    }
    coef = 1.0/a[kk];
    alfaX( coef, &a[kk+n], n, n_1-k);
    // fprintf(AR, " dividir parte de columna %d por  akk\n",k+1);
    // fescrMatr(AR,a,n,n);
    for( i = k+1; i < n; i++) {
      ik = i*n+k;
      XMasAlfaY( &a[ik+1], -a[ik], &a[kk+1], n_1-k);
      // fprintf(AR, " 1 oper. elem.\n");
      // fescrMatr(AR,a,n,n);
    }
    // fprintf(AR, " operaciones elementales\n");
    // fescrMatr(AR,a,n,n);
  }
  det = double(signo)*prod(a, n1, n);
  if( fabs( a[n*n-1] ) <= epsRel ) return 0;
  else return 1;
}
//----------------------------------------------------------
int solPALU(double *a, double *b, int *p, int n, double eps)
{
  // Solucion de Ax = b, si se conoce factorizacion  PA = LU,
  // obtenida a partir de la funcion  PALU.
  // Por seguridad se verifica que no hay  Aii  nulos,
  // |Aii|/max{Aij} <= eps

  // Esquema presentado en Golub, Matrix Computations, pag. 112
  // Devuelve  -1  si  n  es inadecuado
  //            0  si  algun  Aii es nulo o casi.
  //            1  si todo esta bien.
  // La solucion quedara en el arreglo  b


  // Utiliza: maxAbs
  //          minAbs
  //          XMasAlfaY_
  //          prodEsc

  int n1, n_1, k, i, ii;
  double t, epsRel;

  if( n <= 0 ) {
    printf("solPALU:  n  <= 0.\n");
    return -1;
  }
  n1 = n+1;
  n_1 = n-1;

  epsRel = eps*maxAbs(a,n*n);

  if( minAbs(a,n1,n) <= epsRel ) return 0;

  for( k = 0; k < n_1; k++) {
    t = b[k];
    b[k] = b[p[k]];
    b[p[k]] = t;
    XMasAlfaY(&b[k+1],1, -b[k], &a[(k+1)*n+k],n, n_1-k);
  }
  // fprintf(AR, " y : L y = P b.\n");
  // fescrVect(AR, b, n);
  ii = n*n-1;
  for(i = n_1; i >= 0; i--) {
    b[i] -= prodEsc( &a[ii+1], &b[i+1], n_1-i);
    b[i] /= a[ii];
    ii -= n1;
  }
  return 1;
}
//----------------------------------------------------------
int GaussPALU( double *a, double *b, int n, double eps, int *p)
{
  // Solucion de  A x = b  por metodo de Gauss con pivoteo parcial.
  // Se usa factorizacion  PA = LU
  // Esquema presentado en Golub, Matrix Computations, pag. 112
  // La matriz  A  esta almacenada por filas en  a.
  // Si  A  es regular, la solucion quedara en  b
  // El apuntador  p ,  auxiliar debe tener por lo menos  n-1  posiciones.
  // Devuelve  -1  si  n  es inadecuado
  //  0  si  A  es singular o casi.
  //  1  si  A  es regular.  b  tendra la solucion  x.

  // Utiliza:  PALU
  //           solPALU

  int res;
  double determ;

  if( n <= 0 ) {
    printf(" GaussPALU:  n  <= 0.\n");
    return -1;
  }
  // fprintf(AR, " ... %lf\n", b[0]);
  res = PALU(a, n, eps,p, determ);
  // fprintf(AR, " determinante = %lf\n", determ);
  // fprintf(AR, " res = %d\n", res);
  if( res <= 0 ) return res;
  solPALU(a, b, p, n, eps);
  return 1;
}
//----------------------------------------------------------
int tridiag(double *d, double *f, double *u, double *b, int n, 
            double eps)
{
  // solucion de un sistema tridiagonal  de orden  n
  // hay  n   elementos diagonales en       d
  //      n-1 elementos subdiagonales en    f
  //      n-1 elementos superdiagonales en  u
  //      n   terminos independientes en    b
  // 
  // devuelve  1  si se obtuvo la solucion
  //           0  si la matriz no tiene factorizacion  LU;
  //              puede ser singular o puede ser invertible,
  //              simplemente, no se puede aplicar el mtodo.

  // La solucion, cuando la hay, quedar en b.
  // Los arreglos d, f, u, b  quedan modificados.

  // Se supone que los datos estan bien, n >=1, eps adecuado.
 
  int i, n1;

  n1 = n-1;

  for( i = 0; i <= n1; i++) if( fabs(d[i]) <= eps ) return 0;

  for( i=0; i <= n-2; i++ ) {
    f[i] /= d[i];
    d[i+1] -=  f[i]*u[i]; 
    if( fabs(d[i+1]) <= eps ) return 0;
  }

  for( i = 1; i <= n1; i++) b[i] -= f[i-1]*b[i-1];

  b[n1] /= d[n1];  

  for( i = n-2; i >= 0; i--) b[i] = (b[i] - u[i]*b[i+1])/d[i];

  return 1;
}
//----------------------------------------------------------
double det(double *a, int n, double eps)
{
  // Calculo del determinante de  A

  // Utiliza factorizacion  PA = LU

  // Esquema presentado en Golub, Matrix Computations, pag. 112

  // La matriz  A  esta almacenada por filas en  a.

  // El arreglo  a  no se modifica puesto que dentro de esta funcion
  // se toma una copia.

  // Si desea calcular el determinante con menos gasto de memoria, pero
  // modificando el arreglo  a, utilice directamente la funcion  PALU.

  // Utiliza:  PALU

  double *a1, det = 0.0;
  int *p;

  if( n <= 0 ) {
    printf("det:  n  <= 0.\n");
    return det;
  }
  a1 = new double[n*n];
  if( a1 == NULL ) {
    printf(" det: Memoria insuficiente.\n");
    exit(1);
  }
  p = new int[n-1];
  if( p == NULL ) {
    printf(" det: Memoria insuficiente.\n");
    exit(1);
  }
  XIglY(a1,a,n*n);
  PALU(a1, n, eps, p, det);
  delete a1;
  delete p;
  return det;
}
//----------------------------------------------------------
int factChol(double *a, int n, double eps)
{
  // Factorizacion de Choleski de la matriz simetrica A
  // almacenada por filas en el arreglo  a.

  // A = Ut U, U es triangular sup., invertible.

  // Devuelve  0  si A no es definida positiva.
  //   1  si A es definida positiva
  //  en este caso  U  estara en
  //  la parte triangular superior de  A.
  //  -1  si  n <= 0

  // Solamente se trabaja con la parte superior de A.
  // No tiene en cuenta ni verifica si la parte inferior es nula.

  // Utiliza : maxAbs
  //   prodEsc_

  int j, k, n1, kk, kj, kn;
  double t, epsRel;

  if( n <= 0 ) {
    printf("factChol: n <= 0.\n");
    return -1;
  }

  //printf(" A inicial\n");escrSup(a,n);
  n1 = n+1;
  epsRel = eps*maxAbs(a, n*n);
  for( k = 0; k < n; k++) {
    //printf(" k = %d\n", k+1);
    kk = k*n1;
    kn = k*n;
    t = a[kk] - prodEsc( &a[k], n, &a[k], n, k);
    //printf(" t = %lf\n", t);
    if( t <= epsRel ) return 0;
    a[kk] = sqrt(t);

    for( j = k+1; j < n; j++) {
      kj = kn + j;
      a[kj] = (a[kj]-prodEsc(&a[k],n,&a[j],n,k))/a[kk];
    }
    //printf(" k = %d\n", k+1);escrSup(a,n);
  }
  return 1;
}
//----------------------------------------------------------
void solUty(double *u, double *b, int n)
{
  // Solucion del sistema triangular inferior
  // U' y = b,

  // donde  U  es triangular superior y esta
  // en el arreglo  u.
  // Los elementos diagonales deben ser no nulos.

  // Uij  esta en  u[i*n+j].

  // La solucion quedara en  b.

  int i, n1;

  n1 = n+1;
  for( i = 0; i < n; i++) {
    b[i] = (b[i] - prodEsc( &u[i], n, b, 1, i))/u[i*n1];
  }
}
//----------------------------------------------------------
int solChol(double *a, double *b, int n, double eps)
{
  // Solucion por el metodo de Choleski
  // del sistema  A x = b.

  // A debe se simetrica.

  // Devuelve 0 si A no es definida positiva.
  //          1 si A es definida positiva.
  //            En este caso la solucion estara en  b.
  //         -1 si  n <= 0

  // La parte superior de  A  queda modificada.
  // Alli quedara U tal que  U' U = A.

  // Solamente se trabaja con la parte superior de A.

  if( n <= 0 ) {
    printf("solChol: n <= 0.\n");
    return -1;
  }

  if( factChol(a, n, eps) == 0 ) return 0;
  //printf(" U =\n"); escrSup(a, n);
  solUty(a, b, n);
  //printf(" y :\n"); escrVect(b, n);
  solTrSup(a, b, n, eps);
  return 1;
}
//----------------------------------------------------------
void AtA(double *a, double *b, int m, int n)
{
  // B = A' A
  // A es una matriz de tama~no  m x n
  // A esta almacenada, por filas, en el arreglo  a
  // B quedara almacenada, por filas, en el arreglo  b

  int i, j, in;

  for( i = 0; i < n; i++) {
    in = i*n;
    for(j=i;j<n;j++) b[in+j] = prodEsc(&a[i],n, &a[j],n, m);
  }
  for( i = 0; i < n; i++) {
    in = i*n;
    for(j=0;j<i;j++) b[in+j] = b[n*j+i];
  }
}
//----------------------------------------------------------
void AtATrS(double *a, double *b, int m, int n)
{
  // B = A' A
  // A es una matriz de tama~no  m x n
  // A esta almacenada, por filas, en el arreglo  a
  // B quedara almacenada, por filas, en el arreglo  b,
  // pero se almacena de  B  unicamente la parte triangular superior
  // B11 B12 ... B1n B22 ... B2n .... Bnn

  int i, j, k;

  k = 0;
  for( i = 0; i < n; i++) {
    //in = i*n;
    for(j=i;j<n;j++) {
      b[k++] = prodEsc(&a[i],n, &a[j],n, m);
    }
  }
}
//----------------------------------------------------------
int factChol0(double *a, int n, double eps)
{
  // Factorizacion de Choleski de la matriz simetrica A
  // almacenada por filas en el arreglo  a.

  // A = Ut U, U es triangular sup., invertible.

  // Devuelve  0  si A no es definida positiva.
  //   1  si A es definida positiva
  //  en este caso  U  estara en
  //  la parte triangular superior de  A.
  //  -1  si  n <= 0

  // Solamente se trabaja con la parte superior de A.
  // No tiene en cuenta ni verifica si la parte inferior es nula.

  // Utiliza : maxAbs

  int j, k, n1, kk, kj, kn, i, ik, ij;
  double t, epsRel, aik;

  if( n <= 0 ) {
    printf("factChol0: n <= 0.\n");
    return -1;
  }

  //fprintf(AR,"A inicial\n");fescrMatr(AR,a,n,n);
  n1 = n+1;
  epsRel = eps*maxAbs(a, n*n);
  for( k = 0; k < n; k++) {
    //fprintf(AR," k = %d\n", k+1);
    kk = k*n1;
    kn = k*n;
    //t = a[kk] - prodEsc( &a[k], n, &a[k], n, k);
    t = a[kk];
    for( i = 0; i < k; i++) {
      aik = a[i*n+k];
      t -= aik*aik;
    }

    if( t <= epsRel ) return 0;
    a[kk] = sqrt(t);
    //fprintf(AR,"tkk=%lf\n",t);fescrMatr(AR,a,n,n);

    for( j = k+1; j < n; j++) {
      kj = kn + j;
      t = a[kj];
      for( i = 0; i < k; i++) {
        ik = i*n+k;
        ij = i*n+j;
        t -= a[ik]*a[ij];
      }
      a[kj] = t/a[kk];
    }
  }
  return 1;
}
//----------------------------------------------------------
void solUty0(double *u, double *b, int n)
{
  // Solucion del sistema triangular inferior
  // U' y = b,

  // donde  U  es triangular superior y esta
  // en el arreglo  u.
  // Los elementos diagonales deben ser no nulos.

  // Uij  esta en  u[i*n+j].

  // La solucion quedara en  b.

  int i, j, n1, ii, in, ij;
  double t;

  n1 = n+1;
  for( i = 0; i < n; i++) {
    t = b[i];
    ii = i*n1;
    in = i*n;
    for( j = i+1; j < n; j++) {
      ij = in + j;
      t -= u[ij]*b[j];
    }
    b[i] = t/u[ii];
  }
}
//----------------------------------------------------------
int solChol0(double *a, double *b, int n, double eps)
{
  // Solucion por el metodo de Choleski
  // del sistema  A x = b.

  // A debe se simetrica.

  // Devuelve 0 si A no es definida positiva.
  //          1 si A es definida positiva.
  //            En este caso la solucion estara en  b.
  //         -1 si  n <= 0

  // La parte superior de  A  queda modificada.
  // Alli quedara U tal que  U' U = A.

  // Solamente se trabaja con la parte superior de A.

  if( n <= 0 ) {
    printf("solChol0: n <= 0.\n");
    return -1;
  }

  if( factChol0(a, n, eps) == 0 ) return 0;
  //fprintf(AR,"U=\n");fescrVect(AR,a,(n*(n+1))/2);
  solUty0(a, b, n);
  //fprintf(AR,"y:\n"); fescrVect(AR,b, n);
  solTrSup(a, b, n, eps);
  return 1;
}
//----------------------------------------------------------
int factCholTS(double *a, int n, double eps)
{
  // Factorizacion de Choleski de la matriz simetrica A
  // almacenada por filas en el arreglo  a.

  // A = Ut U, U es triangular sup., invertible.

  // Se almacena unicamente la parte triangular superior de  A
  // en el arreglo  a, es decir, el arreglo  a  tiene
  // A11 A12 ... A1n A22 A23 ... A2n A33 ... A3n ... Ann
  // o en la notacion a partir de  0
  // A00 A01 ... A0,n-1 A11 A12 ..., A2,n-1 A22 A23 ... A2,n-1 ... An-1,n-1

  // Devuelve  0  si A no es definida positiva.
  //           1  si A es definida positiva
  //              en este caso  U  estara en
  //              la parte triangular superior de  A.
  //          -1  si  n <= 0

  // Utiliza : maxAbs

  // Considerando la matriz con subindices a partir de  0, es decir,
  // A00 A01 ... A(0,n-1) ... A(n-1,n-1) se tiene la correspondencia:
  //
  //  Aij  <--> a[ij],  ij = i*n - (i*i+i)/2 + j;
  //  Aii  <--> a[i],  ii = i*n - (i*i-i)/2;


  int j, k, i, kk, kj, k0, i0;
  double t, epsRel, aik;


  if( n <= 0 ) {
    printf("factCholTS: n <= 0.\n");
    return -1;
  }

  epsRel = eps*maxAbs(a, n*n);
  for( k = 0; k < n; k++) {
    //fprintf(AR,"\nk=%d\n",k+1);fescrVect(AR,a,(n*(n+1))/2);
    kk = k*n - (k*k-k)/2;
    k0 = kk - k;
    // kk0 = k*n - (k*k+k)/2;
    t = a[kk];
    for( i = 0; i < k; i++) {
      //ik = i*n - (i*i+i)/2 + k;
      aik = a[i*n - (i*i+i)/2 + k];
      t -= aik*aik;
    }
    //fprintf(AR,"tkk=%lf\n",t);
    if( t <= epsRel ) return 0;
    a[kk] = sqrt(t);
    //fescrVect(AR,a,(n*(n+1))/2);
    for( j = k+1; j < n; j++) {
      kj = k0 + j;
      t = a[kj];
      for( i = 0; i < k; i++) {
        i0 = i*n - (i*i+i)/2;
        // ik = i0 + k;
        // ij = i0 + j;
        t -= a[i0+k]*a[i0+j];
      }
      a[kj] = t/a[kk];
    }
    //fprintf(AR, "fin fila\n");fescrVect(AR,a,(n*(n+1))/2);
  }
  return 1;
}
//----------------------------------------------------------
int solUtybTS(double *u, double *b, int n, double eps)
{
  // Solucion de  Ut y = b

  // De la matriz  U  triangular superior, unicamente esta
  // almacenada la parte TRIANGULAR SUPERIOR, fila por fila:
  // U11  U12 ... U1n U22 U23 ... U2n ... Unn
  // La solucion queda en  b
  // Devuelve  1  si todo funciona bien
  //   0  si un elemento diagonal es nulo o casi nulo.
  //  Sin embargo este caso no se deberia presentar.

  double epsRel, t, uii;

  int i, j, nn, ii;

  nn = (n*(n+1))/2;
  epsRel = eps*maxAbs(u, nn);
  for( i=0; i < n; i++) {
    t = b[i];
    ii = i*n - (i*i-i)/2;
    uii = u[ii];
    if( fabs(uii) <= epsRel ) return 0;
    for( j=0; j < i; j++) {
      //lij = uji;
      //ji = j*n - (j*j+j)/2 + i;
      t -= u[j*n-(j*j+j)/2+i]*b[j];
    }
    b[i] = t/uii;
  }
  return 1;
}
//----------------------------------------------------------
int solUxyTS(double *u, double *y, int n, double eps)
{
  // Solucion de  U x = y

  // De la matriz  U  triangular superior, unicamente esta
  // almacenada la parte TRIANGULAR SUPERIOR, fila por fila:
  // U11  U12 ... U1n U22 U23 ... U2n ... Unn
  // La solucion queda en  y
  // Devuelve  1  si todo funciona bien
  //   0  si un elemento diagonal es nulo o casi nulo.
  //  Sin embargo este caso no se deberia presentar.

  double epsRel, t, uii;

  int i, j, nn, i0;

  nn = (n*(n+1))/2;
  epsRel = eps*maxAbs(u, nn);
  for( i = n-1; i >= 0; i--) {
    t = y[i];
    //ii = i*n - (i*i-i)/2;
    uii = u[i*n-(i*i-i)/2];
    i0 = i*n - (i*i+i)/2;
    if( fabs(uii) <= epsRel ) return 0;
    for( j=i+1; j < n; j++) {
      //lij = uji;
      //ij = i*n - (i*i+i)/2 + j;
      //ij = i0+j
      t -= u[i0+j]*y[j];
    }
    y[i] = t/uii;
  }
  return 1;
}
//----------------------------------------------------------
int solCholTS(double *a, double *b, int n, double eps)
{
  // Solucion por el metodo de Choleski
  // del sistema  A x = b.

  // A debe se simetrica. Se almacena unicamente la parte triangular
  // superior en el arreglo  a, es decir, el arreglo  a  tiene
  // A11 A12 ... A1n A22 A23 ... A2n A33 ... A3n ... Ann
  // o en la notacion a partir de  0
  // A00 A01 ... A0,n-1 A11 A12 ..., A2,n-1 A22 A23 ... A2,n-1 ... An-1,n-1

  // Devuelve 0 si A no es definida positiva.
  //          1 si A es definida positiva.
  //            En este caso la solucion estara en  b.
  //         -1 si  n <= 0

  // El arreglo queda modificado. Alli quedara la parte
  // triangular superior de  U,  tal que  U' U = A.

  int res;

  if( n <= 0 ) {
    printf("solCholTS: n <= 0.\n");
    return -1;
  }
  res = factCholTS(a, n, eps);
  if( res == 0 ) return 0;
  //fprintf(AR,"U=\n");fescrVect(AR,a,(n*(n+1))/2);
  res = solUtybTS(a, b, n, eps);
  if( res == 0 ) return 0;
  //fprintf(AR,"y:\n");fescrVect(AR,b,n);
  res = solUxyTS(a, b, n, eps);
  if( res == 0 ) return 0;
  return 1;
}
//----------------------------------------------------------
double **creaMatr1( int m, int n)
{
  // asigna dinamicamente memoria para una matriz  m x n
  // m >= 1,  n >= 1
  // SUBINDICES A PARTIR DE 1
  // devuelve un valor de apuntador a apuntador (apuntador doble)
  //   tipo  double (doble precision)

  double **p;
  int i;

  p = new double *[m] ;
  if( p == NULL ) return( NULL);
  p--;

  for( i = 1; i <= m; i++) {
    p[i] = new double[n];
    if( p[i] == NULL) return( NULL);
    p[i]--;
  }
  return p;
}
//----------------------------------------------------------
void prodMatr1( double **a,double **b,double **c,int m,int n,int p)
{
  // producto de matrices

  // C = A B
  // A es   m x n
  // B es   n x p
  // C sera m x p

  // SUBINDICES A PARTIR DE 1

  double t;
  int i, j, k;

  for( i = 1; i <= m; i++) {
    for( j = 1; j <= p; j++) {
      t = a[i][1]*b[1][j];
      for( k = 2; k <= n; k++) t += a[i][k]*b[k][j];
      c[i][j] = t;
    }
  }
}
//----------------------------------------------------------
void prodMatr( double **a,double **b,double **c,int m,int n,int p)
{
  // producto de matrices

  // C = A B
  // A es   m x n
  // B es   n x p
  // C sera m x p

  // SUBINDICES A PARTIR DE 0

  double t;
  int i, j, k;

  for( i = 0; i < m; i++) {
    for( j = 0; j < p; j++) {
      t = a[i][0]*b[0][j];
      for( k = 1; k < n; k++) t += a[i][k]*b[k][j];
      c[i][j] = t;
    }
  }
}
//-----------------------------------------------------------
int PALU_f(double *a, int n, double eps, int *p)
{
  // factorizacion de la matriz  A  almacenada por filas en  a

  // PA = LU

  // traducido libremente de LINPACK, Dongarra et al., 1978
  // subroutine SGEFA, pag. C-5

  // devuelve  1  si el proceso se desarrollo bien
  //           0  si A es singular o casi.
  // 
  // info  es un variable temporal cuyo valor es 
  // el indice de la columna donde encontro
  //            pivote nulo, entre 0, 1, 2, ..., n-1

  int n_1 = n-1;
  int n1 = n+1;
  double uno = 1.0;
  int info;

  double vamax, t;
  int k, k1, kk, m, m0, mk, j, mn, kn, kj, k1n;
 
  info = -1;

  if( n > 1 ) {
    for( k=0; k < n; k++) {
      k1 = k+1;
      kk = k*n1;
      kn = k*n;
      k1n = k1*n;
      vamax = maxAbsPos( &a[kk], n, n-k, m0);
      m = k+m0; 
      // indice de la fila donde esta el valor dominante
      p[k] = m;
      //printf("m = %d\n", m+1);
      if( vamax > eps ) {
        mk = m*n + k;
        if( m > k ) inter(a[kk], a[mk]);
        t = -uno/a[kk];
        alfaX(t, &a[k1*n+k], n, n_1-k);
        //printf("despues de alfa X.\n");escrMatr(a,n,n);
        mn = m*n;  
        for( j = k1; j < n; j++) {
          t = a[mn+j];
          if( m > k ) {
            kj = kn+j;
            a[mn+j] = a[kj];
            a[kj] = t;
          }
          //printf("antes de XMasAlfaY.\n");escrMatr(a,n,n);
          XMasAlfaY( &a[k1n+j], n, t, &a[k1n+k], n, n_1-k);
          //printf("despues de XMasAlfaY.\n");escrMatr(a,n,n);
        }
      }
      else info = k;
    }
  }
  //p[n-1] = n-1;
  //if( fabs(a[n*n-1]) <= eps ) info = n-1;
    
  if( info == -1 ) return 1;  
  else return 0;
}

//----------------------------------------------------------
int inversa_f(double *a, int n, double eps)
{
  // inversa de la matriz  A  almacenada por filas en  a

  // n = orden de la matriz
  // eps = epsilon: cantida positiva pequena

  // traducido libremente de SGEDI de LINPACK, pag. C-9
  // Dongarra et al., 1978

  // devuelve  1  si de pudo obtener la inversa
  //           0  si  A  es singular o casi.

  // utiliza PALU_f

  int *p;
  double *tmp;
  int res, n1, kk, n_1, kn, kj, k1, i, j, k, ik, l;
  double t, a0;
  double uno  = 1.0;
  double cero = 0.0;

  if( n == 1 ){
    a0 = a[0];
    if( fabs(a0) <= eps ) return 0;
    else{
      a[0] = 1.0/a0;
      return 1;
    }
  }

  n_1 = n-1;
  n1 = n+1;
  p = new int[n];
  tmp = new double[n];

  res = PALU_f(a, n, eps, p);

  //printf("A01 :\n"); escrMatr(a, n, n); escrVectE(p, n);
  //printf("res en SGEDI= %d\n", res);

  if( res == 0 ) return 0;
    for( k = 0; k < n; k++) {
    kn = k*n;
    kk =  k*n1;
    k1 = k+1;
    a[kk] = uno/a[kk];
    t = -a[kk];
    alfaX(t, &a[k], n, k);
    //printf("despues de alfa X.\n");escrMatr(a,n,n);
    if( k < n_1 ) {
      for( j = k+1; j < n; j++) {
        kj = kn+j;
        t = a[kj];
        a[kj] = cero;
        XMasAlfaY( &a[j], n, t, &a[k], n, k+1);
        //printf("despues de x mas alfa y.\n");escrMatr(a,n,n);
      }
    }
  }
    
  //printf("A02.\n");escrMatr(a,n,n);
  for( k = n-2; k >= 0; k--) {
    k1 = k+1;
    for( i = k1; i < n; i++) {
      ik = i*n+k;
      tmp[i] = a[ik];
      a[ik] = cero;
    }
    for( j=k1; j<n; j++) XMasAlfaY(&a[k],n,tmp[j],&a[j],n, n);
    l = p[k];
    if( l != k ) inter(&a[k], n, &a[l], n, n); 
  }
  return 1;
}
//----------------------------------------------------------
int PALU1_n(double **a, int n, int *p, double eps)
{
  // factorizacion PA = LU de una matriz
  // L queda en la parte triangular estrictamente inferior de a 
  // U queda en la parte triangular               superior de a
  // la informacion sobre la matriz P queda en el vector p

  // SUBINDICES A PARTIR DE  1

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular

  // adaptacion libre de ludcmp del libro Numerical Recipes in C

  int i, imax, j, k;
  int nInter; // indica la paridad del numero de intercambios 
  double vMax, t, sum, aaij; 
  double *vv; // vector auxiliar

  vv = new double[n]; 
  vv--;
 
  nInter = 1;

  // "escalamiento"
  for (i = 1; i <= n; i++) { 
    vMax = 0.0; 
    for (j = 1; j <= n; j++) if ((aaij = fabs( a[i][j] ) ) > vMax) vMax = aaij; 
    if( fabs(vMax) <= eps ) {
      // matriz singular o casi
      vv++; delete vv;
      return 0;
    }  
    vv[i] = 1.0/vMax; 
  }
 
  // metodo de Crout
  for (j = 1; j <= n; j++) {  
    for (i = 1; i<j; i++) { 
      sum = a[i][j]; 
      for (k = 1; k<i; k++) sum -= a[i][k]*a[k][j]; 
      a[i][j] = sum; 
    } 
    vMax = 0.0; 
    for (i = j; i <= n; i++) { 
      sum = a[i][j]; 
      for (k = 1; k<j; k++) sum -= a[i][k]*a[k][j]; 
      a[i][j] = sum; 
      if ( (t = vv[i]*fabs(sum)) >= vMax) { 
        vMax = t; 
        imax = i; 
      } 
    } 
    if (j != imax) { 
      //intercambio de filas 
      for (k = 1; k <= n; k++) { 
        t = a[imax][k]; 
        a[imax][k] = a[j][k]; 
        a[j][k] = t; 
      } 
      nInter = -nInter; 
      vv[imax] = vv[j]; 
    } 
    p[j] = imax; 
    if( fabs( a[j][j] ) <= eps ) {
      // matriz singular o casi
      vv++;  delete vv;
      return 0;
    }  
    if (j != n) { 
      t = 1.0/(a[j][j]); 
      for (i = j+1; i <= n; i++) a[i][j] *= t; 
    } 
  } 

  vv++;
  delete vv;
  return 1;
}
//----------------------------------------------------------
void lubksb1(double **a, int n, int *p, double *b)
{
  // adaptacion libre lubksb del libro Numerical Recipes in C

  /*
  Solves the set of n linear equations AX = B. 
  Here a[1..n][1..n] is input, not as the matrix A but rather 
  as its LU decomposition, determined by the routine 
  ludcmp. 
  p[1..n] is input as the permutation vector returned by 
  ludcmp. 
  b[1..n] is input as the right-hand side vector B, and 
  returns with the solution vector X. a, n, and p are not 
  modifed by this routine and can be left in place for 
  successive calls with diferent right-hand sides b. 
  This routine takes into account the possibility that b 
  will begin with many zero elements, so it is efcient 
  for use in matrix inversion.
  */

  int i, ii = 0, ip, j;
  double sum;

  for (i = 1; i <= n; i++) { 
    //When ii is set to a positive value, 
    //it will become the index of the .rst nonvanishing 
    //element of b. 
    //We now do the forward substitution, equation (2.3.6). 
    //The only new wrinkle is to unscramble the permutation
    //as we go.
    ip = p[i];
    sum = b[ip];
    b[ip] = b[i];
    if (ii) for (j = ii; j <= i-1; j++) sum -= a[i][j]*b[j];
    else if (sum) ii = i; 
    //A nonzero element was encountered, so from now on we
    //will have to do the sums in the loop above. 
    b[i] = sum;
  }
  for (i = n; i >= 1; i--) { 
    //Now we do the backsubstitution, equation (2.3.7).
    sum = b[i];
    for (j = i+1; j <= n; j++) sum -= a[i][j]*b[j];
    b[i] = sum/a[i][i]; 
    //Store a component of the solution vector X.
  }
}
//----------------------------------------------------------
int PALU1_g(double **a, int n, int *p, double eps)
{
  // factorizacion PA = LU de una matriz
  // L queda en la parte triangular estrictamente inferior de a 
  // U queda en la parte triangular               superior de a
  // la informacion sobre la matriz P queda en el vector p

  // SUBINDICES A PARTIR DE  1

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular

  // adaptacion del libro de Golub y Van Loan, Matrix Computations

  // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  
  // pero intercambiando las filas completas, para obtener directamente  L

  double vDom, piv;
  int k, mu, n1, k1, i, j;
 
  n1 = n+1;
  for( k = 1; k <= n; k++) {
    k1 = k+1;
    vDom =  maxAbsSubcol(a, k, n, k, mu);
    if( vDom <= eps) return 0;
    p[k] = mu;
    if( mu > k ) inter( &a[k][1], &a[mu][1], n);
    piv = a[k][k];
    for( i = k1; i <= n; i++) {
      a[i][k] /= piv;
      for( j = k1; j <= n; j++ ) a[i][j] -= a[i][k]*a[k][j];
    }
  }
  return 1;
}
//----------------------------------------------------------
int inversa1(double **a, int n,  double eps)
{
  // inversa de una matriz
  // SUBINDICES A PARTIR DE  1

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular
  //          -1  si  la memoria es insuficiente

  // adaptacion del libro Matrix Algorithms, Stewart

  // utiliza PALU1_g

  double s, *temp, t;
  int i, j, res, k;
  int *p;
  
  p = new int[n];
  if( p == NULL ) return -1;
  p--;

  //factorizacion PA = LU

  //res = PALU1_n(a, n, p, eps);
  res = PALU1_g(a, n, p, eps);

  //printf("LU : \n"); escrMatr1(a, n, n);

  if( !res ){
    // matriz no invertible
    p++;
    delete p;
    return 0;
  }
    
  //calculo de inv(U)
  for( k = 1; k <= n; k++) {
    a[k][k] = 1.0/a[k][k];
    for( i = 1; i <= k-1; i++ ) {

      //printf(" i k %d %d\n", i, k );
      //a[i][k] = - a[k][k]*( a(i,i:k-1)*a(i:k-1,k)  );

      s = 0.0;
      for(j = i; j <= k-1; j++) s += a[i][j]*a[j][k];
      a[i][k] = -a[k][k]*s; 
    }
  }

  //printf("U1: \n"); escrMatr1(a, n, n);

  temp = new double[n];
  if( temp == NULL ) return -1;
  temp--;

  // calculo de inv(U)*inv(L)
  for( k = n-1; k >= 1; k--) {

    // temp = a(k+1:n, k)
    for( j = k+1; j <= n; j++) {
      temp[j-k] = a[j][k];
      a[j][k] = 0.0;    
    }

    //a(1:n, k ) = a(1:n, k) - a(1:n, k+1:n)*temp
    for( i = 1; i <= n; i++) {
      t = a[i][k];
      for( j = k+1; j <= n; j++) t -= a[i][j]*temp[j-k];
      a[i][k] = t;
    }    
  } // fin k

  //printf("U1*L1: \n"); escrMatr1(a, n, n);  

  // intercambios
  for( k = n-1; k >= 1; k--) {
    for( i = 1; i <= n; i++ ) {
      t = a[i][k];
      a[i][k] = a[i][p[k]];
      a[i][p[k]] = t;
    }
  }
  p++; delete p;
  temp++; delete temp;

  return 1;
} 
//----------------------------------------------------------
int inversa1_x(double **a, int n,  double eps, double **a1)
{
  // inversa de  a
  // requiere otra matriz   a1, para almacenar  inv(a)
  // NO MUY INTERESANTE

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular

  // utiliza PALU1_n  y  lubksb1

  double *col;
  int i, j, res;
  int *p;
  
  p = new int[n];
  p--;

  res = PALU1_n(a, n, p, eps);
  //printf("res fact = %d\n", res);
  //printf("LU_: \n");  escrMatr1(a, n, n);

  if( !res ){
    p++;
    delete p;
    return 0;
  }

  col = new double[n];
  col--;

  for(j = 1; j <= n; j++) { 
    for(i = 1; i <= n; i++) col[i] = 0.0;
    col[j] = 1.0;
    lubksb1(a, n, p, col);
    for(i = 1; i <= n; i++) a1[i][j] = col[i];
  }
  p++;
  delete p;

  return 1;
}
//----------------------------------------------------------
int PALU_g(double **a, int n, int *p, double eps)
{
  // factorizacion PA = LU de una matriz
  // L queda en la parte triangular estrictamente inferior de a 
  // U queda en la parte triangular               superior de a
  // la informacion sobre la matriz P queda en el vector p

  // SUBINDICES A PARTIR DE  1

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular

  // adaptacion del libro de Golub y Van Loan, Matrix Computations

  // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  
  // pero intercambiando las filas completas, para obtener directamente  L

  double vDom, piv;
  int k, mu, n1, k1, i, j, n_1;

  n1 = n+1;
  n_1 = n-1;
  for( k = 0; k < n; k++) {
    k1 = k+1;
    vDom =  maxAbsSubcol(a, k, n_1, k, mu);
    if( vDom <= eps) return 0;
    p[k] = mu;
    if( mu > k ) inter( &a[k][0], &a[mu][0], n);
    piv = a[k][k];
    for( i = k1; i < n; i++) {
      a[i][k] /= piv;
      for( j = k1; j < n; j++ ) a[i][j] -= a[i][k]*a[k][j];
    }
  }
  return 1;
}
//----------------------------------------------------------
int PALU_g(double *a, int n, int *p, double eps)
{
  // factorizacion PA = LU de una matriz
  // L queda en la parte triangular estrictamente inferior de a 
  // U queda en la parte triangular               superior de a
  // la informacion sobre la matriz P queda en el vector p


  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular

  // adaptacion del libro de Golub y Van Loan, Matrix Computations

  // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  
  // pero intercambiando las filas completas, para obtener directamente  L

  double vDom, piv;
  int k, mu, n1, k1, i, n_1, mu0, kk, ik;

  n1 = n+1;
  n_1 = n-1;
  for( k = 0; k < n; k++) {
    k1 = k+1;
    kk = k*n1;
    vDom =  maxAbsPos( &a[kk], n, n-k, mu0);
    if( vDom <= eps) return 0;
    mu = k+mu0;
    p[k] = mu;
    if( mu > k ) inter( &a[k*n], &a[mu*n], n);
    piv = a[kk];
    for( i = k1; i < n; i++) {
      ik = i*n+k;
      a[ik] /= piv;
      XMasAlfaY( &a[ik+1], 1, -a[ik], &a[kk+1], 1, n-k-1);
     }
  }
  return 1;
}
//----------------------------------------------------------
int inversa(double **a, int n,  double eps)
{
  // inversa de una matriz
  // SUBINDICES A PARTIR DE  0

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular
  //          -1  si  la memoria es insuficiente

  // adaptacion del libro Matrix Algorithms, Stewart

  // utiliza PALU_g

  double s, *temp, t;
  int i, j, res, k;
  int *p;
  
  p = new int[n];
  if( p == NULL ) return -1;

  //factorizacion PA = LU

  res = PALU_g(a, n, p, eps);

  //printf("LU : \n"); escrMatr(a, n, n);

  if( !res ){
    // matriz no invertible
    delete p;
    return 0;
  }
    
  //calculo de inv(U)
  for( k = 0; k < n; k++) {
    a[k][k] = 1.0/a[k][k];
    for( i = 0; i <= k-1; i++ ) {

      //printf(" i k %d %d\n", i, k );
      //a[i][k] = - a[k][k]*( a(i,i:k-1)*a(i:k-1,k)  );

      s = 0.0;
      for(j = i; j <= k-1; j++) s += a[i][j]*a[j][k];
      a[i][k] = -a[k][k]*s; 
    }
  }

  //printf("U1: \n"); escrMatr(a, n, n);

  temp = new double[n];
  if( temp == NULL ) return -1;

  // calculo de inv(U)*inv(L)
  for( k = n-2; k >= 0; k--) {

    // temp = a(k+1:n, k)
    for( j = k+1; j < n; j++) {
      temp[j-k-1] = a[j][k];
      a[j][k] = 0.0;    
    }

    //a(1:n, k ) = a(1:n, k) - a(1:n, k+1:n)*temp
    for( i = 0; i < n; i++) {
      t = a[i][k];
      for( j = k+1; j < n; j++) t -= a[i][j]*temp[j-k-1];
      a[i][k] = t;
    }    
  } // fin k

  //printf("U1*L1: \n"); escrMatr(a, n, n);  

  // intercambios
  for( k = n-2; k >= 0; k--) {
    for( i = 0; i < n; i++ ) {
      t = a[i][k];
      a[i][k] = a[i][p[k]];
      a[i][p[k]] = t;
    }
  }
  delete p;
  delete temp;

  return 1;
}
//----------------------------------------------------------
int inversa(double *a, int n,  double eps)
{
  // inversa de una matriz
  // matriz almacenada por filas en un "vector"

  // devuelve  1  si  a  es invertible
  //           0  si  a  es singular o casi singular
  //          -1  si  la memoria es insuficiente

  // adaptacion del libro Matrix Algorithms, Stewart

  // utiliza PALU_g

  double *temp, t;
  int i, j, res, k, kk, ik, jk, ipk, n1, in, k1, n_k1;
  int *p;
  
  n1 = n+1;
  p = new int[n];
  if( p == NULL ) return -1;

  //factorizacion PA = LU
  res = PALU_g(a, n, p, eps);
  //printf("LU : \n"); escrMatr(a, n, n);

  if( !res ){
    // matriz no invertible
    delete p;
    return 0;
  }
    
  //calculo de inv(U)
  for( k = 0; k < n; k++) {
    kk = k*n1;
    a[kk] = 1.0/a[kk];
    for( i = 0; i <= k-1; i++ ) {
      //a[i][k] = - a[k][k]*( a(i,i:k-1)*a(i:k-1,k)  );

      ik = i*n+k;
      a[ik] = -a[kk]*prodEsc( &a[i*n1], 1, &a[ik], n, k-i); 
    }
  }

  //printf("U1: \n"); escrMatr(a, n, n);

  temp = new double[n];
  if( temp == NULL ) return -1;

  // calculo de inv(U)*inv(L)
  for( k = n-2; k >= 0; k--) {
    k1 = k+1;
    n_k1 = n-k1;

    // temp = a(k+1:n, k)
    for( j = k1; j < n; j++) {
      jk = j*n+k;
      temp[j-k1] = a[jk];
      a[jk] = 0.0;    
    }

    //a(1:n, k ) = a(1:n, k) - a(1:n, k+1:n)*temp
    for( i = 0; i < n; i++) {
      ik = i*n+k;
      a[ik] -= prodEsc( &a[ik+1], 1, temp, 1, n_k1);
    } 
   
  } // fin k

  //printf("U1*L1: \n"); escrMatr(a, n, n);  

  // intercambios
  for( k = n-2; k >= 0; k--) {
    for( i = 0; i < n; i++ ) {
      in = i*n;
      ik = in+k;
      ipk = in+p[k];
      t = a[ik];
      a[ik] = a[ipk];
      a[ipk] = t;
    }
  }
  delete p;
  delete temp;
  return 1;
} 
